/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.auto.value.AutoValue;
import java.util.Map;
import java.util.Set;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.errors.SearchError;
import org.graylog.plugins.views.search.rest.AutoValue_SearchJobDTO;
import org.graylog.plugins.views.search.rest.AutoValue_SearchJobDTO_ExecutionInfo;

@JsonAutoDetect
@JsonPropertyOrder(value={"execution", "results"})
@AutoValue
public abstract class SearchJobDTO {
    @JsonProperty
    abstract String id();

    @JsonProperty(value="search_id")
    abstract String searchId();

    @JsonProperty
    abstract String owner();

    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    abstract Set<SearchError> errors();

    @JsonProperty
    public abstract Map<String, QueryResult> results();

    @JsonProperty
    abstract ExecutionInfo execution();

    public static SearchJobDTO fromSearchJob(SearchJob searchJob) {
        return Builder.create().id(searchJob.getId()).owner(searchJob.getOwner()).errors(searchJob.getErrors()).results(searchJob.results()).searchId(searchJob.getSearchId()).execution(ExecutionInfo.fromExecutionInfo(searchJob.execution())).build();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder id(String var1);

        abstract Builder searchId(String var1);

        abstract Builder owner(String var1);

        abstract Builder errors(Set<SearchError> var1);

        abstract Builder results(Map<String, QueryResult> var1);

        abstract Builder execution(ExecutionInfo var1);

        abstract SearchJobDTO build();

        static Builder create() {
            return new AutoValue_SearchJobDTO.Builder();
        }
    }

    @AutoValue
    static abstract class ExecutionInfo {
        ExecutionInfo() {
        }

        @JsonProperty
        abstract boolean done();

        @JsonProperty
        abstract boolean cancelled();

        @JsonProperty(value="completed_exceptionally")
        abstract boolean hasErrors();

        public static ExecutionInfo fromExecutionInfo(SearchJob.ExecutionInfo execution) {
            return new AutoValue_SearchJobDTO_ExecutionInfo(execution.done, execution.cancelled, execution.hasErrors);
        }
    }
}

