/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.rest.resources;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.plugins.sidecar.rest.models.Collector;
import org.graylog.plugins.sidecar.rest.models.CollectorUpload;
import org.graylog.plugins.sidecar.rest.models.Configuration;
import org.graylog.plugins.sidecar.rest.models.ConfigurationSummary;
import org.graylog.plugins.sidecar.rest.models.Sidecar;
import org.graylog.plugins.sidecar.rest.requests.ConfigurationPreviewRequest;
import org.graylog.plugins.sidecar.rest.responses.CollectorUploadListResponse;
import org.graylog.plugins.sidecar.rest.responses.ConfigurationListResponse;
import org.graylog.plugins.sidecar.rest.responses.ConfigurationPreviewRenderResponse;
import org.graylog.plugins.sidecar.rest.responses.ConfigurationSidecarsResponse;
import org.graylog.plugins.sidecar.services.CollectorService;
import org.graylog.plugins.sidecar.services.ConfigurationService;
import org.graylog.plugins.sidecar.services.EtagService;
import org.graylog.plugins.sidecar.services.ImportService;
import org.graylog.plugins.sidecar.services.SidecarService;
import org.graylog.plugins.sidecar.template.RenderTemplateException;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.database.PaginatedList;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.plugin.rest.ValidationResult;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryParser;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Sidecar/Configurations", description="Manage/Render collector configurations", tags={"cloud"})
@Path(value="/sidecar/configurations")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@RequiresAuthentication
public class ConfigurationResource
extends RestResource
implements PluginRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationResource.class);
    private static final Pattern VALID_NAME_PATTERN = Pattern.compile("^[^;*?\"<>|&]+$");
    private final ConfigurationService configurationService;
    private final SidecarService sidecarService;
    private final EtagService etagService;
    private final ImportService importService;
    private final CollectorService collectorService;
    private final SearchQueryParser searchQueryParser;
    private static final ImmutableMap<String, SearchQueryField> SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"id", (Object)SearchQueryField.create("id")).put((Object)"collector_id", (Object)SearchQueryField.create("collector_id")).put((Object)"name", (Object)SearchQueryField.create("name")).build();

    @Inject
    public ConfigurationResource(ConfigurationService configurationService, SidecarService sidecarService, EtagService etagService, ImportService importService, CollectorService collectorService) {
        this.configurationService = configurationService;
        this.sidecarService = sidecarService;
        this.etagService = etagService;
        this.importService = importService;
        this.collectorService = collectorService;
        this.searchQueryParser = new SearchQueryParser("name", (Map<String, SearchQueryField>)SEARCH_FIELD_MAPPING);
    }

    @GET
    @RequiresPermissions(value={"sidecar_collector_configurations:read"})
    @Produces(value={"application/json"})
    @ApiOperation(value="List all configurations")
    public ConfigurationListResponse listConfigurations(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="name,id,collector_id") @DefaultValue(value="name") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="asc") @QueryParam(value="order") String order) {
        SearchQuery searchQuery = this.searchQueryParser.parse(query);
        PaginatedList<Configuration> configurations = this.configurationService.findPaginated(searchQuery, page, perPage, sort, order);
        long total = this.configurationService.count();
        List<ConfigurationSummary> result = configurations.stream().map(ConfigurationSummary::create).collect(Collectors.toList());
        return ConfigurationListResponse.create(query, configurations.pagination(), total, sort, order, result);
    }

    @GET
    @Path(value="/uploads")
    @RequiresPermissions(value={"sidecar_collector_configurations:read"})
    @Produces(value={"application/json"})
    @ApiOperation(value="List all uploaded configurations")
    public CollectorUploadListResponse listImports(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page) {
        PaginatedList<CollectorUpload> uploads = this.importService.findPaginated(page, 10, "created", "desc");
        long total = this.importService.count();
        ArrayList<CollectorUpload> result = new ArrayList<CollectorUpload>((Collection<CollectorUpload>)((Object)uploads));
        return CollectorUploadListResponse.create(uploads.pagination(), total, result);
    }

    @GET
    @Path(value="/{id}")
    @RequiresPermissions(value={"sidecar_collector_configurations:read"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Show configuration details")
    public Configuration getConfigurations(@ApiParam(name="id", required=true) @PathParam(value="id") String id) {
        Configuration configuration = this.configurationService.find(id);
        if (configuration == null) {
            throw new NotFoundException("Could not find Configuration <" + id + ">.");
        }
        return configuration;
    }

    @GET
    @Path(value="/{id}/sidecars")
    @RequiresPermissions(value={"sidecar_collector_configurations:read", "sidecars:read"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Show sidecars using the given configuration")
    public ConfigurationSidecarsResponse getConfigurationSidecars(@ApiParam(name="id", required=true) @PathParam(value="id") String id) {
        Configuration configuration = this.configurationService.find(id);
        if (configuration == null) {
            throw new NotFoundException("Could not find Configuration <" + id + ">.");
        }
        List<String> sidecarsWithConfiguration = this.sidecarService.all().stream().filter(sidecar -> this.isConfigurationAssignedToSidecar(configuration.id(), (Sidecar)sidecar)).map(Sidecar::id).collect(Collectors.toList());
        return ConfigurationSidecarsResponse.create(configuration.id(), sidecarsWithConfiguration);
    }

    @POST
    @Path(value="/validate")
    @NoAuditEvent(value="Validation only")
    @RequiresPermissions(value={"sidecar_collector_configurations:read"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Validates configuration parameters")
    public ValidationResult validateConfiguration(@Valid @ApiParam(value="configuration") Configuration toValidate) {
        return this.validate(toValidate);
    }

    @GET
    @Timed
    @Path(value="/render/{sidecarId}/{configurationId}")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"sidecar_collector_configurations:read"})
    @ApiOperation(value="Render configuration template")
    public Response renderConfiguration(@Context HttpHeaders httpHeaders, @ApiParam(name="sidecarId", required=true) @PathParam(value="sidecarId") String sidecarId, @ApiParam(name="configurationId", required=true) @PathParam(value="configurationId") String configurationId) throws RenderTemplateException, JsonProcessingException {
        EntityTag etag;
        String ifNoneMatch = httpHeaders.getHeaderString("If-None-Match");
        boolean etagCached = false;
        Response.ResponseBuilder builder = Response.noContent();
        if (ifNoneMatch != null && this.etagService.configurationsAreCached((etag = new EntityTag(ifNoneMatch.replaceAll("\"", ""))).toString())) {
            etagCached = true;
            builder = Response.notModified();
            builder.tag(etag);
        }
        if (!etagCached) {
            Sidecar sidecar = this.sidecarService.findByNodeId(sidecarId);
            if (sidecar == null) {
                throw new NotFoundException("Couldn't find Sidecar by ID: " + sidecarId);
            }
            Configuration configuration = this.configurationService.find(configurationId);
            if (configuration == null) {
                throw new NotFoundException("Couldn't find configuration by ID: " + configurationId);
            }
            Configuration collectorConfiguration = this.configurationService.renderConfigurationForCollector(sidecar, configuration);
            EntityTag collectorConfigurationEtag = this.etagService.buildEntityTagForResponse(collectorConfiguration);
            builder = Response.ok((Object)collectorConfiguration);
            builder.tag(collectorConfigurationEtag);
            this.etagService.registerConfiguration(collectorConfigurationEtag.toString());
        }
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoTransform(true);
        cacheControl.setPrivate(true);
        builder.cacheControl(cacheControl);
        return builder.build();
    }

    @POST
    @Path(value="/render/preview")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"sidecar_collector_configurations:read"})
    @ApiOperation(value="Render preview of a configuration template")
    @NoAuditEvent(value="this is not changing any data")
    public ConfigurationPreviewRenderResponse renderConfiguration(@ApiParam(name="JSON body", required=true) @Valid @NotNull ConfigurationPreviewRequest request) {
        try {
            String preview = this.configurationService.renderPreview(request.template());
            return ConfigurationPreviewRenderResponse.create(preview);
        }
        catch (RenderTemplateException e) {
            throw new BadRequestException("Could not render template preview: " + e.getMessage());
        }
    }

    @POST
    @RequiresPermissions(value={"sidecar_collector_configurations:create"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create new configuration")
    @AuditEvent(type="sidecar:configuration:create")
    public Response createConfiguration(@ApiParam(name="JSON body", required=true) @Valid @NotNull Configuration request) {
        Configuration configuration = this.configurationFromRequest(null, request);
        ValidationResult validationResult = this.validate(configuration);
        if (validationResult.failed()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)validationResult).build();
        }
        Configuration config = this.configurationService.save(configuration);
        if (!config.tags().isEmpty()) {
            String os = Optional.ofNullable(this.collectorService.find(request.collectorId())).map(Collector::nodeOperatingSystem).orElse("");
            this.sidecarService.findByTagsAndOS(config.tags(), os).map(Sidecar::nodeId).forEach(this.etagService::invalidateRegistration);
        }
        return Response.ok().entity((Object)config).build();
    }

    @POST
    @Path(value="/{id}/{name}")
    @RequiresPermissions(value={"sidecar_collector_configurations:read", "sidecar_collector_configurations:create"})
    @ApiOperation(value="Copy a configuration")
    @AuditEvent(type="sidecar:configuration:clone")
    public Response copyConfiguration(@ApiParam(name="id", required=true) @PathParam(value="id") String id, @PathParam(value="name") String name) throws NotFoundException {
        Configuration configuration = this.configurationService.copyConfiguration(id, name);
        ValidationResult validationResult = this.validate(configuration);
        if (validationResult.failed()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)validationResult).build();
        }
        this.configurationService.save(configuration);
        return Response.accepted().build();
    }

    @PUT
    @Path(value="/{id}")
    @RequiresPermissions(value={"sidecar_collector_configurations:update"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a configuration")
    @AuditEvent(type="sidecar:configuration:update")
    public Response updateConfiguration(@ApiParam(name="id", required=true) @PathParam(value="id") String id, @ApiParam(name="JSON body", required=true) @Valid @NotNull Configuration request) {
        Configuration previousConfiguration = this.configurationService.find(id);
        if (previousConfiguration == null) {
            throw new NotFoundException("Could not find Configuration <" + id + ">.");
        }
        if (!previousConfiguration.collectorId().equals(request.collectorId()) && this.isConfigurationInUse(id)) {
            throw new BadRequestException("Configuration still in use, cannot change collector type.");
        }
        Configuration updatedConfiguration = this.configurationFromRequest(id, request);
        ValidationResult validationResult = this.validate(updatedConfiguration);
        if (validationResult.failed()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)validationResult).build();
        }
        this.etagService.invalidateAllConfigurations();
        if (!previousConfiguration.tags().equals(updatedConfiguration.tags())) {
            Sets.SetView tags = Sets.symmetricDifference(previousConfiguration.tags(), updatedConfiguration.tags());
            String os = Optional.ofNullable(this.collectorService.find(request.collectorId())).map(Collector::nodeOperatingSystem).orElse("");
            this.sidecarService.findByTagsAndOS((Collection<String>)tags, os).map(Sidecar::nodeId).forEach(this.etagService::invalidateRegistration);
        }
        return Response.ok().entity((Object)this.configurationService.save(updatedConfiguration)).build();
    }

    @DELETE
    @Path(value="/{id}")
    @RequiresPermissions(value={"sidecar_collector_configurations:delete"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a configuration")
    @AuditEvent(type="sidecar:configuration:delete")
    public Response deleteConfiguration(@ApiParam(name="id", required=true) @PathParam(value="id") String id) {
        if (this.isConfigurationInUse(id)) {
            throw new BadRequestException("Configuration still in use, cannot delete.");
        }
        int deleted = this.configurationService.delete(id);
        if (deleted == 0) {
            return Response.notModified().build();
        }
        this.etagService.invalidateAllConfigurations();
        return Response.accepted().build();
    }

    private ValidationResult validate(Configuration toValidate) {
        Configuration configuration;
        ValidationResult validation = new ValidationResult();
        Optional<Configuration> configurationOptional = Optional.ofNullable(this.configurationService.findByName(toValidate.name()));
        if (configurationOptional.isPresent() && !(configuration = configurationOptional.get()).id().equals(toValidate.id())) {
            validation.addError("name", "Configuration \"" + toValidate.name() + "\" already exists");
        }
        if (toValidate.name().isEmpty()) {
            validation.addError("name", "Configuration name cannot be empty.");
        } else if (!VALID_NAME_PATTERN.matcher(toValidate.name()).matches()) {
            validation.addError("name", "Configuration name can not include the following characters: ; * ? \" < > | &");
        }
        if (toValidate.collectorId().isEmpty()) {
            validation.addError("collector_id", "Associated collector ID cannot be empty.");
        }
        if (toValidate.color().isEmpty()) {
            validation.addError("color", "Collector color cannot be empty.");
        }
        if (toValidate.template().isEmpty()) {
            validation.addError("template", "Collector template cannot be empty.");
        }
        try {
            this.configurationService.renderPreview(toValidate.template());
        }
        catch (RenderTemplateException e) {
            validation.addError("template", "Template error: " + e.getMessage());
        }
        return validation;
    }

    private boolean isConfigurationInUse(String configurationId) {
        return this.sidecarService.all().stream().anyMatch(sidecar -> this.isConfigurationAssignedToSidecar(configurationId, (Sidecar)sidecar));
    }

    private boolean isConfigurationAssignedToSidecar(String configurationId, Sidecar sidecar) {
        List assignments = (List)MoreObjects.firstNonNull(sidecar.assignments(), new ArrayList());
        return assignments.stream().anyMatch(assignment -> assignment.configurationId().equals(configurationId));
    }

    private Configuration configurationFromRequest(String id, Configuration request) {
        Configuration configuration = id == null ? this.configurationService.fromRequest(request) : this.configurationService.fromRequest(id, request);
        return configuration;
    }
}

