/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.export;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.elasticsearch.QueryStringDecorators;
import org.graylog.plugins.views.search.export.ExportException;
import org.graylog.plugins.views.search.export.ExportMessagesCommand;
import org.graylog.plugins.views.search.export.MessagesRequest;
import org.graylog.plugins.views.search.export.ResultFormat;
import org.graylog.plugins.views.search.searchtypes.MessageList;
import org.graylog2.decorators.Decorator;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

public class CommandFactory {
    private final QueryStringDecorators queryStringDecorator;

    @Inject
    public CommandFactory(QueryStringDecorators queryStringDecorator) {
        this.queryStringDecorator = queryStringDecorator;
    }

    public ExportMessagesCommand buildFromRequest(MessagesRequest request) {
        ExportMessagesCommand.Builder builder = ExportMessagesCommand.builder().timeRange(this.toAbsolute(request.timeRange())).queryString(request.queryString()).streams(request.streams()).fieldsInOrder(request.fieldsInOrder()).chunkSize(request.chunkSize());
        request.timeZone().ifPresent(builder::timeZone);
        request.limit().ifPresent(builder::limit);
        return builder.build();
    }

    public ExportMessagesCommand buildWithSearchOnly(Search search, ResultFormat resultFormat) {
        Query query = this.queryFrom(search);
        return this.builderFrom(resultFormat).timeRange(resultFormat.timerange().orElse(this.toAbsolute(query.timerange()))).queryString(this.queryStringFrom(search, query)).streams(query.usedStreamIds()).build();
    }

    private Query queryFrom(Search s) {
        if (s.queries().size() > 1) {
            throw new ExportException("Can't get messages for search with id " + s.id() + ", because it contains multiple queries");
        }
        return (Query)s.queries().stream().findFirst().orElseThrow(() -> new ExportException("Invalid Search object with empty Query"));
    }

    public ExportMessagesCommand buildWithMessageList(Search search, String messageListId, ResultFormat resultFormat) {
        Query query = search.queryForSearchType(messageListId);
        SearchType searchType = this.searchTypeFrom(query, messageListId);
        List<Decorator> decorators = searchType instanceof MessageList ? ((MessageList)searchType).decorators() : Collections.emptyList();
        ExportMessagesCommand.Builder commandBuilder = this.builderFrom(resultFormat).timeRange(resultFormat.timerange().orElse(this.toAbsolute(this.timeRangeFrom(query, searchType)))).queryString(this.queryStringFrom(search, query, searchType)).streams(query.effectiveStreams(searchType)).decorators(decorators);
        return commandBuilder.build();
    }

    private SearchType searchTypeFrom(Query query, String searchTypeId) {
        SearchType searchType = query.searchTypes().stream().filter(st -> st.id().equals(searchTypeId)).findFirst().orElseThrow(() -> new IllegalArgumentException("Error getting search type"));
        if (!searchType.isExportable()) {
            throw new ExportException("export is not supported for search type " + searchType.getClass());
        }
        return searchType;
    }

    private AbsoluteRange toAbsolute(TimeRange timeRange) {
        return AbsoluteRange.create(timeRange.getFrom(), timeRange.getTo());
    }

    private ExportMessagesCommand.Builder builderFrom(ResultFormat resultFormat) {
        ExportMessagesCommand.Builder requestBuilder = ExportMessagesCommand.builder().fieldsInOrder(resultFormat.fieldsInOrder());
        resultFormat.limit().ifPresent(requestBuilder::limit);
        resultFormat.timeZone().ifPresent(requestBuilder::timeZone);
        return requestBuilder;
    }

    private TimeRange timeRangeFrom(Query query, SearchType searchType) {
        if (searchType.timerange().isPresent()) {
            return query.effectiveTimeRange(searchType);
        }
        return query.timerange();
    }

    private ElasticsearchQueryString queryStringFrom(Search search, Query query) {
        ElasticsearchQueryString undecorated = this.queryStringFrom(query);
        return this.decorateQueryString(search, query, undecorated);
    }

    private ElasticsearchQueryString queryStringFrom(Search search, Query query, SearchType searchType) {
        ElasticsearchQueryString undecorated = this.pickQueryString(searchType, query);
        return this.decorateQueryString(search, query, undecorated);
    }

    private ElasticsearchQueryString pickQueryString(SearchType searchType, Query query) {
        if (searchType.query().isPresent() && this.hasQueryString(query)) {
            return this.esQueryStringFrom(query).concatenate(this.esQueryStringFrom(searchType));
        }
        if (searchType.query().isPresent()) {
            return this.esQueryStringFrom(searchType);
        }
        return this.queryStringFrom(query);
    }

    private boolean hasQueryString(Query query) {
        return query.query() instanceof ElasticsearchQueryString;
    }

    private ElasticsearchQueryString queryStringFrom(Query query) {
        return this.hasQueryString(query) ? this.esQueryStringFrom(query) : ElasticsearchQueryString.empty();
    }

    private ElasticsearchQueryString esQueryStringFrom(SearchType searchType) {
        return (ElasticsearchQueryString)searchType.query().get();
    }

    private ElasticsearchQueryString esQueryStringFrom(Query query) {
        return (ElasticsearchQueryString)query.query();
    }

    private ElasticsearchQueryString decorateQueryString(Search search, Query query, ElasticsearchQueryString undecorated) {
        String queryString = undecorated.queryString();
        String decorated = this.queryStringDecorator.decorate(queryString, search, query);
        return ElasticsearchQueryString.of(decorated);
    }
}

