/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.searchfilters.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.searchfilters.model.InlineQueryStringSearchFilter;

final class AutoValue_InlineQueryStringSearchFilter
extends InlineQueryStringSearchFilter {
    @Nullable
    private final String title;
    private final Optional<String> id;
    @Nullable
    private final String description;
    private final String queryString;
    private final boolean negation;
    private final boolean disabled;

    private AutoValue_InlineQueryStringSearchFilter(@Nullable String title, Optional<String> id, @Nullable String description, String queryString, boolean negation, boolean disabled) {
        this.title = title;
        this.id = id;
        this.description = description;
        this.queryString = queryString;
        this.negation = negation;
        this.disabled = disabled;
    }

    @Override
    @JsonProperty(value="title")
    @Nullable
    public String title() {
        return this.title;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    public Optional<String> id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="queryString")
    public String queryString() {
        return this.queryString;
    }

    @Override
    @JsonProperty(value="negation", defaultValue="false")
    public boolean negation() {
        return this.negation;
    }

    @Override
    @JsonProperty(value="disabled", defaultValue="false")
    public boolean disabled() {
        return this.disabled;
    }

    public String toString() {
        return "InlineQueryStringSearchFilter{title=" + this.title + ", id=" + this.id + ", description=" + this.description + ", queryString=" + this.queryString + ", negation=" + this.negation + ", disabled=" + this.disabled + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InlineQueryStringSearchFilter) {
            InlineQueryStringSearchFilter that = (InlineQueryStringSearchFilter)o;
            return (this.title == null ? that.title() == null : this.title.equals(that.title())) && this.id.equals(that.id()) && (this.description == null ? that.description() == null : this.description.equals(that.description())) && this.queryString.equals(that.queryString()) && this.negation == that.negation() && this.disabled == that.disabled();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.title == null ? 0 : this.title.hashCode();
        h$ *= 1000003;
        h$ ^= this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.description == null ? 0 : this.description.hashCode();
        h$ *= 1000003;
        h$ ^= this.queryString.hashCode();
        h$ *= 1000003;
        h$ ^= this.negation ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.disabled ? 1231 : 1237;
    }

    @Override
    public InlineQueryStringSearchFilter.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends InlineQueryStringSearchFilter.Builder {
        private String title;
        private Optional<String> id = Optional.empty();
        private String description;
        private String queryString;
        private boolean negation;
        private boolean disabled;
        private byte set$0;

        Builder() {
        }

        private Builder(InlineQueryStringSearchFilter source) {
            this.title = source.title();
            this.id = source.id();
            this.description = source.description();
            this.queryString = source.queryString();
            this.negation = source.negation();
            this.disabled = source.disabled();
            this.set$0 = (byte)3;
        }

        @Override
        public InlineQueryStringSearchFilter.Builder title(String title) {
            this.title = title;
            return this;
        }

        @Override
        public InlineQueryStringSearchFilter.Builder id(@Nullable String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        public InlineQueryStringSearchFilter.Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public InlineQueryStringSearchFilter.Builder queryString(String queryString) {
            if (queryString == null) {
                throw new NullPointerException("Null queryString");
            }
            this.queryString = queryString;
            return this;
        }

        @Override
        public InlineQueryStringSearchFilter.Builder negation(boolean negation) {
            this.negation = negation;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public InlineQueryStringSearchFilter.Builder disabled(boolean disabled) {
            this.disabled = disabled;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        public InlineQueryStringSearchFilter build() {
            if (this.set$0 != 3 || this.queryString == null) {
                StringBuilder missing = new StringBuilder();
                if (this.queryString == null) {
                    missing.append(" queryString");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" negation");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" disabled");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_InlineQueryStringSearchFilter(this.title, this.id, this.description, this.queryString, this.negation, this.disabled);
        }
    }
}

