/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler;

import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.Updates;
import java.util.Objects;
import javax.inject.Inject;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;
import org.bson.conversions.Bson;
import org.graylog.scheduler.JobDefinitionDto;
import org.graylog.shaded.mongojack4.org.mongojack.JacksonMongoCollection;
import org.graylog2.database.MongoCollections;
import org.graylog2.shared.utilities.StringUtils;

public class DBCustomJobDefinitionService {
    private final JacksonMongoCollection<JobDefinitionDto> db;

    @Inject
    public DBCustomJobDefinitionService(MongoCollections collections) {
        this.db = (JacksonMongoCollection)collections.get("scheduler_job_definitions", JobDefinitionDto.class);
    }

    public JobDefinitionDto findOrCreate(JobDefinitionDto dto) {
        String jobDefinitionId = Objects.requireNonNull(dto.id(), "Job definition ID cannot be null");
        Codec codec = this.db.getCodecRegistry().get(JobDefinitionDto.class);
        try (BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());){
            codec.encode((BsonWriter)writer, (Object)dto, EncoderContext.builder().build());
            JobDefinitionDto jobDefinitionDto = (JobDefinitionDto)this.db.findOneAndUpdate(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)jobDefinitionId), Filters.eq((String)StringUtils.f("%s.%s", "config", "type"), (Object)dto.config().type())}), Updates.setOnInsert((Bson)writer.getDocument()), new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER).upsert(true));
            return jobDefinitionDto;
        }
    }
}

