/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import java.nio.file.Path;
import java.security.KeyStore;
import java.time.Duration;
import org.graylog.security.certutil.ca.CACreator;
import org.graylog.security.certutil.console.CommandLineConsole;
import org.graylog.security.certutil.console.SystemConsole;
import org.graylog.security.certutil.keystore.storage.KeystoreFileStorage;
import org.graylog.security.certutil.keystore.storage.SinglePasswordKeystoreContentMover;
import org.graylog.security.certutil.keystore.storage.location.KeystoreFileLocation;
import org.graylog2.bootstrap.CliCommand;

@Command(name="ca", description="Manage certificate authority for data-node", groupNames={"certutil"})
public class CertutilCa
implements CliCommand {
    @Option(name={"--filename"}, description="Filename for the CA keystore")
    protected String keystoreFilename = "datanode-ca.p12";
    private final CommandLineConsole console;
    private final CACreator caCreator;
    private final KeystoreFileStorage caKeystoreStorage;
    public static final CommandLineConsole.Prompt PROMPT_ENTER_CA_PASSWORD = CommandLineConsole.prompt("Enter CA password: ");

    public CertutilCa() {
        this.console = new SystemConsole();
        this.caCreator = new CACreator();
        this.caKeystoreStorage = new KeystoreFileStorage(new SinglePasswordKeystoreContentMover());
    }

    public CertutilCa(String keystoreFilename, CommandLineConsole console) {
        this.keystoreFilename = keystoreFilename;
        this.console = console;
        this.caCreator = new CACreator();
        this.caKeystoreStorage = new KeystoreFileStorage(new SinglePasswordKeystoreContentMover());
    }

    @Override
    public void run() {
        try {
            this.console.printLine("This tool will generate a self-signed certificate authority for datanode");
            char[] password = this.console.readPassword(PROMPT_ENTER_CA_PASSWORD);
            this.console.printLine("Generating datanode CA");
            Duration certificateValidity = Duration.ofDays(3650L);
            KeyStore caKeystore = this.caCreator.createCA(password, certificateValidity);
            this.console.printLine("Private keys and certificates for root and intermediate CA generated");
            Path keystorePath = Path.of(this.keystoreFilename, new String[0]);
            this.caKeystoreStorage.writeKeyStore(new KeystoreFileLocation(keystorePath), caKeystore, password, (char[])null);
            this.console.printLine("Keys and certificates stored in " + keystorePath.toAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate CA certificate", e);
        }
    }
}

