/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.csr;

import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.graylog2.plugin.certificates.RenewalPolicy;

public class CsrSigner {
    private final Clock clock;

    public CsrSigner() {
        this.clock = Clock.systemDefaultZone();
    }

    public CsrSigner(Clock clock) {
        this.clock = clock;
    }

    private boolean isValidName(int name) {
        return switch (name) {
            case 1, 2, 7 -> true;
            default -> false;
        };
    }

    private Duration periodToDuration(Period period) {
        return Duration.ofDays((long)period.getYears() * 365L + (long)period.getMonths() * 30L + (long)period.getDays());
    }

    private Duration safeParse(String duration) {
        try {
            return Duration.parse(duration);
        }
        catch (DateTimeParseException ignored) {
            return this.periodToDuration(Period.parse(duration));
        }
    }

    private Instant plusIsoDuration(Instant validFrom, String duration) {
        return validFrom.plus(this.safeParse(duration));
    }

    public X509Certificate sign(PrivateKey caPrivateKey, X509Certificate caCertificate, PKCS10CertificationRequest csr, RenewalPolicy renewalPolicy) throws Exception {
        Instant validFrom = Instant.now(this.clock);
        Instant validUntil = this.plusIsoDuration(validFrom, renewalPolicy.certificateLifetime());
        return this.sign(caPrivateKey, caCertificate, csr, validFrom, validUntil);
    }

    public X509Certificate sign(PrivateKey caPrivateKey, X509Certificate caCertificate, PKCS10CertificationRequest csr, int validityDays) throws Exception {
        Instant validFrom = Instant.now(this.clock);
        Instant validUntil = validFrom.plus(Duration.ofDays(validityDays));
        return this.sign(caPrivateKey, caCertificate, csr, validFrom, validUntil);
    }

    private X509Certificate sign(PrivateKey caPrivateKey, X509Certificate caCertificate, PKCS10CertificationRequest csr, Instant validFrom, Instant validUntil) throws Exception {
        BigInteger serialNumber = BigInteger.valueOf(System.currentTimeMillis());
        X500Name issuerName = X500Name.getInstance((Object)caCertificate.getSubjectX500Principal().getEncoded());
        PrivateKey issuerKey = caPrivateKey;
        X509v3CertificateBuilder builder = new X509v3CertificateBuilder(issuerName, serialNumber, Date.from(validFrom), Date.from(validUntil), csr.getSubject(), csr.getSubjectPublicKeyInfo());
        Attribute[] certAttributes = csr.getAttributes(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest);
        if (certAttributes != null && certAttributes.length > 0) {
            ArrayList altNames = new ArrayList();
            for (Attribute attribute : certAttributes) {
                Extensions extensions = Extensions.getInstance((Object)attribute.getAttrValues().getObjectAt(0));
                GeneralNames gns = GeneralNames.fromExtensions((Extensions)extensions, (ASN1ObjectIdentifier)Extension.subjectAlternativeName);
                if (gns == null || gns.getNames() == null) continue;
                Arrays.stream(gns.getNames()).filter(n -> this.isValidName(n.getTagNo())).forEach(altNames::add);
            }
            if (!altNames.isEmpty()) {
                builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(altNames.toArray(new GeneralName[altNames.size()])));
            }
        }
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").build(issuerKey);
        X509CertificateHolder certHolder = builder.build(signer);
        X509Certificate cert = new JcaX509CertificateConverter().getCertificate(certHolder);
        return cert;
    }
}

