/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.csr.storage;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Optional;
import javax.inject.Inject;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.OperatorException;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.graylog2.cluster.preflight.DataNodeProvisioningConfig;
import org.graylog2.cluster.preflight.DataNodeProvisioningService;

public class CsrMongoStorage {
    private DataNodeProvisioningService mongoService;

    @Inject
    public CsrMongoStorage(DataNodeProvisioningService mongoService) {
        this.mongoService = mongoService;
    }

    public void writeCsr(PKCS10CertificationRequest csr, String nodeId) throws IOException, OperatorException {
        try (StringWriter writer = new StringWriter();){
            try (JcaPEMWriter jcaPEMWriter = new JcaPEMWriter((Writer)writer);){
                jcaPEMWriter.writeObject((Object)csr);
            }
            this.mongoService.writeCsr(nodeId, writer.toString());
        }
    }

    public Optional<PKCS10CertificationRequest> readCsr(String nodeId) throws IOException, OperatorException {
        BufferedReader pemReader;
        PEMParser pemParser;
        Object parsedObj;
        String csr;
        DataNodeProvisioningConfig preflightConfig = this.mongoService.getPreflightConfigFor(nodeId);
        if (preflightConfig != null && (csr = preflightConfig.csr()) != null && (parsedObj = (pemParser = new PEMParser((Reader)(pemReader = new BufferedReader(new StringReader(csr))))).readObject()) instanceof PKCS10CertificationRequest) {
            return Optional.of((PKCS10CertificationRequest)parsedObj);
        }
        return Optional.empty();
    }
}

