/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings;

import com.floreysoft.jmte.Engine;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.glassfish.grizzly.http.server.ErrorPageGenerator;
import org.graylog.scheduler.capabilities.ServerNodeCapabilitiesModule;
import org.graylog2.Configuration;
import org.graylog2.alerts.AlertSender;
import org.graylog2.alerts.EmailRecipients;
import org.graylog2.alerts.FormattedEmailAlertSender;
import org.graylog2.bindings.providers.ClusterEventBusProvider;
import org.graylog2.bindings.providers.DefaultSecurityManagerProvider;
import org.graylog2.bindings.providers.DefaultStreamProvider;
import org.graylog2.bindings.providers.HtmlSafeJmteEngineProvider;
import org.graylog2.bindings.providers.SecureFreemarkerConfigProvider;
import org.graylog2.bindings.providers.SystemJobFactoryProvider;
import org.graylog2.bindings.providers.SystemJobManagerProvider;
import org.graylog2.bootstrap.uncaughtexeptions.DefaultUncaughtExceptionHandlerCreator;
import org.graylog2.cluster.ClusterConfigServiceImpl;
import org.graylog2.cluster.leader.FakeLeaderElectionModule;
import org.graylog2.cluster.leader.LeaderElectionModule;
import org.graylog2.cluster.lock.LockServiceModule;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.grok.GrokModule;
import org.graylog2.grok.GrokPatternRegistry;
import org.graylog2.indexer.SetIndexReadOnlyJob;
import org.graylog2.indexer.fieldtypes.FieldTypesModule;
import org.graylog2.indexer.healing.FixDeflectorByDeleteJob;
import org.graylog2.indexer.healing.FixDeflectorByMoveJob;
import org.graylog2.indexer.indices.jobs.IndexSetCleanupJob;
import org.graylog2.indexer.indices.jobs.OptimizeIndexJob;
import org.graylog2.indexer.indices.jobs.SetIndexReadOnlyAndCalculateRangeJob;
import org.graylog2.indexer.ranges.CreateNewSingleIndexRangeJob;
import org.graylog2.indexer.ranges.RebuildIndexRangesJob;
import org.graylog2.inputs.InputEventListener;
import org.graylog2.inputs.InputStateListener;
import org.graylog2.inputs.PersistedInputsImpl;
import org.graylog2.lookup.LookupModule;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.cluster.ClusterIdFactory;
import org.graylog2.plugin.cluster.RandomUUIDClusterIdFactory;
import org.graylog2.plugin.inject.Graylog2Module;
import org.graylog2.plugin.rest.ValidationFailureExceptionMapper;
import org.graylog2.plugin.streams.DefaultStream;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.rest.ElasticsearchExceptionMapper;
import org.graylog2.rest.GenericErrorCsvWriter;
import org.graylog2.rest.GraylogErrorPageGenerator;
import org.graylog2.rest.NotFoundExceptionMapper;
import org.graylog2.rest.QueryParsingExceptionMapper;
import org.graylog2.rest.ScrollChunkWriter;
import org.graylog2.rest.ValidationExceptionMapper;
import org.graylog2.rest.resources.entities.preferences.listeners.EntityListPreferencesCleanerOnUserDeletion;
import org.graylog2.security.realm.AuthenticatingRealmModule;
import org.graylog2.security.realm.AuthorizationOnlyRealmModule;
import org.graylog2.shared.buffers.processors.ProcessBufferProcessor;
import org.graylog2.shared.inputs.PersistedInputs;
import org.graylog2.shared.messageq.MessageQueueModule;
import org.graylog2.shared.metrics.jersey2.MetricsDynamicBinding;
import org.graylog2.shared.rest.resources.csp.CSPDynamicFeature;
import org.graylog2.shared.rest.resources.csp.CSPEventListener;
import org.graylog2.shared.rest.resources.csp.CSPService;
import org.graylog2.shared.rest.resources.csp.CSPServiceImpl;
import org.graylog2.shared.security.RestrictToLeaderFeature;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.graylog2.storage.SupportedSearchVersionDynamicFeature;
import org.graylog2.streams.DefaultStreamChangeHandler;
import org.graylog2.streams.StreamRouter;
import org.graylog2.streams.StreamRouterEngine;
import org.graylog2.system.activities.SystemMessageActivityWriter;
import org.graylog2.system.debug.ClusterDebugEventListener;
import org.graylog2.system.debug.LocalDebugEventListener;
import org.graylog2.system.jobs.SystemJobFactory;
import org.graylog2.system.jobs.SystemJobManager;
import org.graylog2.system.shutdown.GracefulShutdown;
import org.graylog2.system.stats.ClusterStatsModule;
import org.graylog2.telemetry.enterprise.DefaultTelemetryEnterpriseDataProvider;
import org.graylog2.telemetry.enterprise.TelemetryEnterpriseDataProvider;
import org.graylog2.users.GrantsCleanupListener;
import org.graylog2.users.RoleService;
import org.graylog2.users.RoleServiceImpl;
import org.graylog2.users.StartPageCleanupListener;
import org.graylog2.users.UserImpl;

public class ServerBindings
extends Graylog2Module {
    private final Configuration configuration;
    private final boolean isMigrationCommand;

    public ServerBindings(Configuration configuration, boolean isMigrationCommand) {
        this.configuration = configuration;
        this.isMigrationCommand = isMigrationCommand;
    }

    protected void configure() {
        this.bindInterfaces();
        this.bindSingletons();
        if (this.isMigrationCommand) {
            this.configuration.setMessageJournalEnabled(false);
        }
        this.install((Module)new MessageQueueModule(this.configuration));
        this.bindProviders();
        this.bindFactoryModules();
        this.bindDynamicFeatures();
        this.bindExceptionMappers();
        this.bindAdditionalJerseyComponents();
        if (!this.isMigrationCommand) {
            this.bindEventBusListeners();
        }
        this.install((Module)new AuthenticatingRealmModule(this.configuration));
        this.install((Module)new AuthorizationOnlyRealmModule());
        this.bindSearchResponseDecorators();
        this.install((Module)new GrokModule());
        this.install((Module)new LookupModule(this.configuration));
        this.install((Module)new FieldTypesModule());
        if (this.isMigrationCommand) {
            this.install((Module)new FakeLeaderElectionModule());
        } else {
            this.install((Module)new LeaderElectionModule(this.configuration));
        }
        this.install((Module)new LockServiceModule());
        this.install((Module)new ServerNodeCapabilitiesModule());
        this.outputsMapBinder2();
    }

    private void bindProviders() {
        this.bind(ClusterEventBus.class).toProvider(ClusterEventBusProvider.class).asEagerSingleton();
        this.bind(freemarker.template.Configuration.class).toProvider(SecureFreemarkerConfigProvider.class);
    }

    private void bindFactoryModules() {
        this.install(new FactoryModuleBuilder().build(RebuildIndexRangesJob.Factory.class));
        this.install(new FactoryModuleBuilder().build(OptimizeIndexJob.Factory.class));
        this.install(new FactoryModuleBuilder().build(SetIndexReadOnlyJob.Factory.class));
        this.install(new FactoryModuleBuilder().build(IndexSetCleanupJob.Factory.class));
        this.install(new FactoryModuleBuilder().build(CreateNewSingleIndexRangeJob.Factory.class));
        this.install(new FactoryModuleBuilder().build(FixDeflectorByDeleteJob.Factory.class));
        this.install(new FactoryModuleBuilder().build(FixDeflectorByMoveJob.Factory.class));
        this.install(new FactoryModuleBuilder().build(SetIndexReadOnlyAndCalculateRangeJob.Factory.class));
        this.install(new FactoryModuleBuilder().build(UserImpl.Factory.class));
        this.install(new FactoryModuleBuilder().build(EmailRecipients.Factory.class));
        this.install(new FactoryModuleBuilder().build(ProcessBufferProcessor.Factory.class));
        this.bind(Stream.class).annotatedWith(DefaultStream.class).toProvider(DefaultStreamProvider.class);
        this.bind(DefaultStreamChangeHandler.class).asEagerSingleton();
    }

    private void bindSingletons() {
        this.bind(DefaultUncaughtExceptionHandlerCreator.class).asEagerSingleton();
        this.bind(SystemJobManager.class).toProvider(SystemJobManagerProvider.class);
        this.bind(DefaultSecurityManager.class).toProvider(DefaultSecurityManagerProvider.class).asEagerSingleton();
        this.bind(SystemJobFactory.class).toProvider(SystemJobFactoryProvider.class);
        this.bind(GracefulShutdown.class).in(Scopes.SINGLETON);
        this.bind(ClusterStatsModule.class).asEagerSingleton();
        this.bind(ClusterConfigService.class).to(ClusterConfigServiceImpl.class).asEagerSingleton();
        this.bind(GrokPatternRegistry.class).in(Scopes.SINGLETON);
        this.bind(Engine.class).toInstance((Object)Engine.createEngine());
        this.bind(Engine.class).annotatedWith((Annotation)Names.named((String)"HtmlSafe")).toProvider(HtmlSafeJmteEngineProvider.class).asEagerSingleton();
        this.bind(ErrorPageGenerator.class).to(GraylogErrorPageGenerator.class).asEagerSingleton();
    }

    private void bindInterfaces() {
        this.bind(AlertSender.class).to(FormattedEmailAlertSender.class);
        this.bind(StreamRouter.class);
        this.install(new FactoryModuleBuilder().implement(StreamRouterEngine.class, StreamRouterEngine.class).build(StreamRouterEngine.Factory.class));
        this.bind(ActivityWriter.class).to(SystemMessageActivityWriter.class);
        this.bind(PersistedInputs.class).to(PersistedInputsImpl.class);
        this.bind(RoleService.class).to(RoleServiceImpl.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)this.binder(), ClusterIdFactory.class).setDefault().to(RandomUUIDClusterIdFactory.class);
        OptionalBinder.newOptionalBinder((Binder)this.binder(), TelemetryEnterpriseDataProvider.class).setDefault().to(DefaultTelemetryEnterpriseDataProvider.class);
        this.bind(CSPService.class).to(CSPServiceImpl.class).asEagerSingleton();
        this.bind(CSPEventListener.class).asEagerSingleton();
    }

    private void bindDynamicFeatures() {
        Multibinder<Class<? extends DynamicFeature>> dynamicFeatures = this.jerseyDynamicFeatureBinder();
        dynamicFeatures.addBinding().toInstance(MetricsDynamicBinding.class);
        dynamicFeatures.addBinding().toInstance(RestrictToLeaderFeature.class);
        dynamicFeatures.addBinding().toInstance(SupportedSearchVersionDynamicFeature.class);
        dynamicFeatures.addBinding().toInstance(CSPDynamicFeature.class);
    }

    private void bindExceptionMappers() {
        Multibinder<Class<? extends ExceptionMapper>> exceptionMappers = this.jerseyExceptionMapperBinder();
        exceptionMappers.addBinding().toInstance(NotFoundExceptionMapper.class);
        exceptionMappers.addBinding().toInstance(ValidationExceptionMapper.class);
        exceptionMappers.addBinding().toInstance(ValidationFailureExceptionMapper.class);
        exceptionMappers.addBinding().toInstance(ElasticsearchExceptionMapper.class);
        exceptionMappers.addBinding().toInstance(QueryParsingExceptionMapper.class);
    }

    private void bindAdditionalJerseyComponents() {
        this.jerseyAdditionalComponentsBinder().addBinding().toInstance(ScrollChunkWriter.class);
        this.jerseyAdditionalComponentsBinder().addBinding().toInstance(GenericErrorCsvWriter.class);
    }

    private void bindEventBusListeners() {
        this.bind(InputStateListener.class).asEagerSingleton();
        this.bind(InputEventListener.class).asEagerSingleton();
        this.bind(LocalDebugEventListener.class).asEagerSingleton();
        this.bind(ClusterDebugEventListener.class).asEagerSingleton();
        this.bind(StartPageCleanupListener.class).asEagerSingleton();
        this.bind(GrantsCleanupListener.class).asEagerSingleton();
        this.bind(EntityListPreferencesCleanerOnUserDeletion.class).asEagerSingleton();
    }

    private void bindSearchResponseDecorators() {
        this.searchResponseDecoratorBinder();
    }
}

