/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight;

import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.graylog.security.certutil.CaConfiguration;
import org.graylog.security.certutil.CaService;
import org.graylog.security.certutil.ca.exceptions.KeyStoreStorageException;
import org.graylog.security.certutil.cert.CertificateChain;
import org.graylog.security.certutil.cert.storage.CertChainMongoStorage;
import org.graylog.security.certutil.cert.storage.CertChainStorage;
import org.graylog.security.certutil.csr.CsrSigner;
import org.graylog.security.certutil.csr.storage.CsrMongoStorage;
import org.graylog2.Configuration;
import org.graylog2.bootstrap.preflight.PreflightConfigResult;
import org.graylog2.bootstrap.preflight.PreflightConfigService;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeService;
import org.graylog2.cluster.preflight.DataNodeProvisioningConfig;
import org.graylog2.cluster.preflight.DataNodeProvisioningService;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.certificates.RenewalPolicy;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.security.CustomCAX509TrustManager;
import org.graylog2.security.IndexerJwtAuthTokenProvider;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GraylogCertificateProvisioningPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(GraylogCertificateProvisioningPeriodical.class);
    private static final int THREADPOOL_THREADS = 5;
    private static final int CONNECTION_ATTEMPTS = 40;
    private static final int WAIT_BETWEEN_CONNECTION_ATTEMPTS = 3;
    private static final int RATIO_WHEN_WE_START_SHOWING_EXCEPTIONS = 2;
    private final DataNodeProvisioningService dataNodeProvisioningService;
    private final NodeService nodeService;
    private final CaConfiguration configuration;
    private final CsrMongoStorage csrStorage;
    private final CertChainStorage certMongoStorage;
    private final CaService caService;
    private final CsrSigner csrSigner;
    private final ClusterConfigService clusterConfigService;
    private final String passwordSecret;
    private final EventBus serverEventBus;
    private Optional<OkHttpClient> okHttpClient = Optional.empty();
    private final PreflightConfigService preflightConfigService;
    private final IndexerJwtAuthTokenProvider indexerJwtAuthTokenProvider;
    private final NotificationService notificationService;
    private final ExecutorService executor;

    @Inject
    public GraylogCertificateProvisioningPeriodical(DataNodeProvisioningService dataNodeProvisioningService, CsrMongoStorage csrStorage, CertChainMongoStorage certMongoStorage, CaService caService, Configuration configuration, NodeService nodeService, CsrSigner csrSigner, ClusterConfigService clusterConfigService, @Named(value="password_secret") String passwordSecret, IndexerJwtAuthTokenProvider indexerJwtAuthTokenProvider, PreflightConfigService preflightConfigService, EventBus serverEventBus, NotificationService notificationService) {
        this.dataNodeProvisioningService = dataNodeProvisioningService;
        this.csrStorage = csrStorage;
        this.certMongoStorage = certMongoStorage;
        this.caService = caService;
        this.passwordSecret = passwordSecret;
        this.configuration = configuration;
        this.nodeService = nodeService;
        this.csrSigner = csrSigner;
        this.clusterConfigService = clusterConfigService;
        this.serverEventBus = serverEventBus;
        this.preflightConfigService = preflightConfigService;
        this.indexerJwtAuthTokenProvider = indexerJwtAuthTokenProvider;
        this.notificationService = notificationService;
        this.executor = Executors.newFixedThreadPool(5, new ThreadFactoryBuilder().setNameFormat("provisioning-connectivity-check-task").build());
    }

    private Optional<OkHttpClient> buildConnectivityCheckOkHttpClient() {
        try {
            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                CustomCAX509TrustManager tm = new CustomCAX509TrustManager(this.caService, this.serverEventBus);
                sslContext.init(null, new TrustManager[]{tm}, new SecureRandom());
                clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)tm);
            }
            catch (NoSuchAlgorithmException ex) {
                LOG.error("Could not set Graylog CA trustmanager: {}", (Object)ex.getMessage(), (Object)ex);
            }
            return Optional.of(clientBuilder.build());
        }
        catch (Exception ex) {
            LOG.error("Could not create temporary okhttpclient " + ex.getMessage(), (Throwable)ex);
            return Optional.empty();
        }
    }

    private RenewalPolicy getRenewalPolicy() {
        return this.clusterConfigService.get(RenewalPolicy.class);
    }

    @Override
    public void doRun() {
        LOG.debug("checking if there are configuration steps to take care of");
        try {
            List<DataNodeProvisioningConfig> nodes = this.dataNodeProvisioningService.findAllNodesThatNeedAttention();
            if (!nodes.isEmpty()) {
                boolean hasNodesWithCSR;
                char[] password = this.configuration.configuredCaExists() ? this.configuration.getCaPassword().toCharArray() : this.passwordSecret.toCharArray();
                Optional<KeyStore> optKey = this.caService.loadKeyStore();
                if (optKey.isEmpty()) {
                    LOG.debug("No keystore available.");
                    return;
                }
                RenewalPolicy renewalPolicy = this.getRenewalPolicy();
                if (renewalPolicy == null) {
                    LOG.debug("No renewal policy available.");
                    return;
                }
                if (this.okHttpClient.isEmpty()) {
                    this.okHttpClient = this.buildConnectivityCheckOkHttpClient();
                }
                Map<DataNodeProvisioningConfig.State, List<DataNodeProvisioningConfig>> nodesByState = nodes.stream().collect(Collectors.groupingBy(node -> Optional.ofNullable(node.state()).orElse(DataNodeProvisioningConfig.State.UNCONFIGURED)));
                PreflightConfigResult cfg = this.preflightConfigService.getPreflightConfigResult();
                if (cfg.equals((Object)PreflightConfigResult.FINISHED)) {
                    List unconfiguredNodes = nodesByState.getOrDefault((Object)DataNodeProvisioningConfig.State.UNCONFIGURED, List.of());
                    if (renewalPolicy.mode().equals((Object)RenewalPolicy.Mode.AUTOMATIC)) {
                        unconfiguredNodes.forEach(c -> this.dataNodeProvisioningService.save(c.toBuilder().state(DataNodeProvisioningConfig.State.CONFIGURED).build()));
                    } else {
                        boolean hasUnconfiguredNodes;
                        boolean bl = hasUnconfiguredNodes = !unconfiguredNodes.isEmpty();
                        if (hasUnconfiguredNodes) {
                            Notification notification = this.notificationService.buildNow().addType(Notification.Type.DATA_NODE_NEEDS_PROVISIONING).addSeverity(Notification.Severity.URGENT);
                            this.notificationService.publishIfFirst(notification);
                        } else {
                            this.notificationService.fixed(Notification.Type.DATA_NODE_NEEDS_PROVISIONING);
                        }
                    }
                }
                KeyStore caKeystore = optKey.get();
                List nodesWithCSR = nodesByState.getOrDefault((Object)DataNodeProvisioningConfig.State.CSR, List.of());
                boolean bl = hasNodesWithCSR = !nodesWithCSR.isEmpty();
                if (hasNodesWithCSR) {
                    PrivateKey caPrivateKey = (PrivateKey)caKeystore.getKey("ca", password);
                    X509Certificate caCertificate = (X509Certificate)caKeystore.getCertificate("ca");
                    nodesWithCSR.forEach(c -> {
                        try {
                            Optional<PKCS10CertificationRequest> csr = this.csrStorage.readCsr(c.nodeId());
                            if (csr.isEmpty()) {
                                LOG.error("Node in CSR state, but no CSR present : " + c.nodeId());
                                this.dataNodeProvisioningService.save(c.toBuilder().state(DataNodeProvisioningConfig.State.ERROR).errorMsg("Node in CSR state, but no CSR present").build());
                            } else {
                                X509Certificate cert = this.csrSigner.sign(caPrivateKey, caCertificate, csr.get(), renewalPolicy);
                                List<X509Certificate> caCertificates = List.of(caCertificate);
                                this.certMongoStorage.writeCertChain(new CertificateChain(cert, caCertificates), c.nodeId());
                            }
                        }
                        catch (Exception e) {
                            LOG.error("Could not sign CSR: " + e.getMessage(), (Throwable)e);
                            this.dataNodeProvisioningService.save(c.toBuilder().state(DataNodeProvisioningConfig.State.ERROR).errorMsg(e.getMessage()).build());
                        }
                    });
                }
                nodesByState.getOrDefault((Object)DataNodeProvisioningConfig.State.STORED, List.of()).forEach(c -> {
                    this.dataNodeProvisioningService.save(c.toBuilder().state(DataNodeProvisioningConfig.State.CONNECTING).build());
                    this.executor.submit(() -> {
                        try {
                            this.checkConnectivity((DataNodeProvisioningConfig)c);
                        }
                        catch (RetryException | ExecutionException e) {
                            LOG.error("Exception trying to connect to node " + c.nodeId() + ": " + e.getMessage(), e);
                            this.dataNodeProvisioningService.save(c.toBuilder().state(DataNodeProvisioningConfig.State.ERROR).errorMsg(e.getMessage()).build());
                        }
                    });
                });
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | KeyStoreStorageException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkConnectivity(final DataNodeProvisioningConfig config) throws ExecutionException, RetryException {
        LOG.info("Starting connectivity check with node {}", (Object)config.nodeId());
        final AtomicInteger counter = new AtomicInteger(0);
        String nodeId = config.nodeId();
        RetryerBuilder.newBuilder().withWaitStrategy(WaitStrategies.fixedWait((long)3L, (TimeUnit)TimeUnit.SECONDS)).withStopStrategy(StopStrategies.stopAfterAttempt((int)40)).withRetryListener(new RetryListener(){

            public <V> void onRetry(Attempt<V> attempt) {
                LOG.debug("Waiting for datanode {} to come up, attempt {}", (Object)config.nodeId(), (Object)attempt.getAttemptNumber());
                counter.incrementAndGet();
            }
        }).retryIfResult(check -> Objects.equals("false", check)).build().call(() -> {
            try {
                Node node = this.nodeService.byNodeId(nodeId);
                Request request = new Request.Builder().url(node.getTransportAddress()).build();
                if (!this.okHttpClient.isPresent()) return "false";
                OkHttpClient.Builder builder = this.okHttpClient.get().newBuilder();
                builder.authenticator((route, response) -> response.request().newBuilder().header("Authorization", this.indexerJwtAuthTokenProvider.get()).build());
                Call call = builder.build().newCall(request);
                try (Response response2 = call.execute();){
                    if (response2.isSuccessful()) {
                        this.dataNodeProvisioningService.save(config.toBuilder().state(DataNodeProvisioningConfig.State.CONNECTED).build());
                        LOG.info("Connectivity check successful with node {}", (Object)nodeId);
                        String string = "true";
                        return string;
                    }
                    String string = "false";
                    return string;
                }
            }
            catch (Exception e) {
                if (counter.get() <= 20) return "false";
                LOG.warn("Exception trying to connect to node " + config.nodeId() + ": " + e.getMessage() + ", retrying", (Throwable)e);
                return "false";
            }
        });
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean leaderOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 2;
    }

    @Override
    public int getPeriodSeconds() {
        return 2;
    }
}

