/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.cluster;

import com.google.common.collect.ImmutableList;
import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.Configuration;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeImpl;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.plugin.system.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeServiceImpl
extends PersistedServiceImpl
implements NodeService {
    private static final Logger LOG = LoggerFactory.getLogger(NodeServiceImpl.class);
    public static final String LAST_SEEN_FIELD = "$last_seen";
    private final long pingTimeout;
    private static final Map<String, Object> lastSeenFieldDefinition = Map.of("last_seen", Map.of("$type", "timestamp"));
    private static final DBObject addLastSeenFieldAsDate = new BasicDBObject("$addFields", Map.of("last_seen_date", Map.of("$cond", Map.of("if", Map.of("$isNumber", "$last_seen"), "then", Map.of("$toDate", Map.of("$toLong", "$last_seen")), "else", Map.of("$toDate", Map.of("$dateToString", Map.of("date", "$last_seen")))))));

    @Inject
    public NodeServiceImpl(MongoConnection mongoConnection, Configuration configuration) {
        this(mongoConnection, configuration.getStaleLeaderTimeout());
    }

    public NodeServiceImpl(MongoConnection mongoConnection, int staleLeaderTimeout) {
        super(mongoConnection);
        this.pingTimeout = staleLeaderTimeout;
    }

    @Override
    public Node.Type type() {
        return Node.Type.SERVER;
    }

    private Map<String, Object> addClusterUriToMap(Map<String, Object> orig, String clusterUri) {
        if (clusterUri == null) {
            return orig;
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>(orig);
        newMap.put("cluster_address", clusterUri);
        return Map.copyOf(newMap);
    }

    @Override
    public boolean registerServer(String nodeId, boolean isLeader, URI httpPublishUri, String clusterUri, String hostname) {
        Map<String, Object> params = this.addClusterUriToMap(Map.of("node_id", nodeId, "type", this.type().toString(), "is_leader", isLeader, "transport_address", httpPublishUri.toString(), "hostname", hostname), clusterUri);
        Map<String, Map<String, Object>> fields = Map.of("$set", params, "$currentDate", lastSeenFieldDefinition);
        WriteResult result = this.collection(NodeImpl.class).update((DBObject)new BasicDBObject("node_id", (Object)nodeId), (DBObject)new BasicDBObject(fields), true, false);
        return result.getN() == 1;
    }

    @Override
    public Node byNodeId(String nodeId) throws NodeNotFoundException {
        BasicDBObject query = new BasicDBObject("node_id", (Object)nodeId);
        DBObject o = this.findOne(NodeImpl.class, (DBObject)query);
        if (o == null || !o.containsField("node_id")) {
            throw new NodeNotFoundException("Unable to find node " + nodeId);
        }
        return new NodeImpl((ObjectId)o.get("_id"), o.toMap());
    }

    @Override
    public Node byNodeId(NodeId nodeId) throws NodeNotFoundException {
        return this.byNodeId(nodeId.getNodeId());
    }

    @Override
    public Map<String, Node> byNodeIds(Collection<String> nodeIds) {
        return this.query(NodeImpl.class, (DBObject)new BasicDBObject("node_id", (Object)new BasicDBObject("$in", nodeIds))).stream().map(o -> new NodeImpl((ObjectId)o.get("_id"), o.toMap())).collect(Collectors.toMap(NodeImpl::getNodeId, Function.identity()));
    }

    private Stream<DBObject> aggregate(List<? extends DBObject> pipeline) {
        return this.cursorToStream((Iterator<DBObject>)this.collection(NodeImpl.class).aggregate(pipeline, AggregationOptions.builder().build()));
    }

    @Override
    public Map<String, Node> allActive(Node.Type type) {
        return this.aggregate(this.recentHeartbeat(List.of(Map.of("type", type.toString())))).collect(Collectors.toMap(obj -> (String)obj.get("node_id"), obj -> new NodeImpl((ObjectId)obj.get("_id"), obj.toMap())));
    }

    @Override
    @Deprecated
    public Map<String, Node> allActive() {
        return this.allActive(this.type());
    }

    private List<? extends DBObject> recentHeartbeat(List<? extends Map<String, Object>> additionalMatches) {
        ImmutableList match = ImmutableList.builder().add(Map.of("$expr", Map.of("$gte", List.of("$last_seen_date", Map.of("$subtract", List.of("$$NOW", Long.valueOf(this.pingTimeout))))))).addAll(additionalMatches).build();
        return List.of(addLastSeenFieldAsDate, new BasicDBObject("$match", Map.of("$and", match)), new BasicDBObject("$unset", (Object)"last_seen_date"));
    }

    @Override
    public void dropOutdated() {
        List<Object> outdatedIds = this.aggregate(List.of(addLastSeenFieldAsDate, new BasicDBObject("$match", Map.of("$expr", Map.of("$lt", List.of("$last_seen_date", Map.of("$subtract", List.of("$$NOW", Long.valueOf(this.pingTimeout))))))), new BasicDBObject("$project", Map.of("_id", "$_id")))).map(obj -> obj.get("_id")).toList();
        if (!outdatedIds.isEmpty()) {
            BasicDBObject query = new BasicDBObject("_id", Map.of("$in", outdatedIds));
            this.destroyAll(NodeImpl.class, (DBObject)query);
        }
    }

    private Stream<DBObject> cursorToStream(Iterator<DBObject> cursor) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(cursor, 16), false);
    }

    @Override
    public void markAsAlive(NodeId node, boolean isLeader, URI restTransportAddress, String clusterAddress) throws NodeNotFoundException {
        BasicDBObject query = new BasicDBObject("node_id", (Object)node.getNodeId());
        Map<String, Object> params = this.addClusterUriToMap(Map.of("is_leader", isLeader, "transport_address", restTransportAddress.toString()), clusterAddress);
        BasicDBObject update = new BasicDBObject(Map.of("$set", params, "$currentDate", lastSeenFieldDefinition));
        WriteResult result = super.collection(NodeImpl.class).update((DBObject)query, (DBObject)update);
        int updatedDocumentsCount = result.getN();
        if (updatedDocumentsCount != 1) {
            throw new NodeNotFoundException("Unable to find node " + node.getNodeId());
        }
    }

    @Override
    public boolean isOnlyLeader(NodeId nodeId) {
        if (this.type() != Node.Type.SERVER) {
            LOG.warn("Caution, isOnlyLeader called in the {} context, but returning only results of type {}", (Object)this.type(), (Object)Node.Type.SERVER);
        }
        return this.aggregate(this.recentHeartbeat(List.of(Map.of("type", Node.Type.SERVER.toString(), "node_id", new BasicDBObject("$ne", (Object)nodeId.getNodeId()), "is_leader", true)))).findAny().isEmpty();
    }

    @Override
    public boolean isAnyLeaderPresent() {
        if (this.type() != Node.Type.SERVER) {
            LOG.warn("Caution, isOnlyLeader called in the {} context, but returning only results of type {}", (Object)this.type(), (Object)Node.Type.SERVER);
        }
        return this.aggregate(this.recentHeartbeat(List.of(Map.of("type", Node.Type.SERVER.toString(), "is_leader", true)))).findAny().isPresent();
    }
}

