/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import com.google.common.base.Suppliers;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.graylog2.bootstrap.preflight.PreflightConfigResult;
import org.graylog2.bootstrap.preflight.PreflightConfigService;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexerDiscoveryProvider
implements Provider<List<URI>> {
    private static final Logger LOG = LoggerFactory.getLogger(IndexerDiscoveryProvider.class);
    public static final URI DEFAULT_INDEXER_HOST = URI.create("http://127.0.0.1:9200");
    private final List<URI> hosts;
    private final PreflightConfigService preflightConfigService;
    private final NodeService nodeService;
    private final Supplier<List<URI>> resultsCachingSupplier;

    @Inject
    public IndexerDiscoveryProvider(@Named(value="elasticsearch_hosts") List<URI> hosts, PreflightConfigService preflightConfigService, NodeService nodeService) {
        this.hosts = hosts;
        this.preflightConfigService = preflightConfigService;
        this.nodeService = nodeService;
        this.resultsCachingSupplier = Suppliers.memoize(this::doGet);
    }

    public List<URI> get() {
        return this.resultsCachingSupplier.get();
    }

    private List<URI> doGet() {
        if (this.hosts != null && !this.hosts.isEmpty()) {
            return this.hosts;
        }
        PreflightConfigResult preflightResult = this.preflightConfigService.getPreflightConfigResult();
        if (preflightResult == PreflightConfigResult.FINISHED) {
            List<URI> discovered = this.discover();
            if (!discovered.isEmpty()) {
                return discovered;
            }
            throw new IllegalStateException("No Datanode available, terminating.");
        }
        LOG.info("No indexer hosts configured, using fallback {}", (Object)DEFAULT_INDEXER_HOST);
        return Collections.singletonList(DEFAULT_INDEXER_HOST);
    }

    private List<URI> discover() {
        return this.nodeService.allActive(Node.Type.DATANODE).values().stream().map(Node::getTransportAddress).map(URI::create).collect(Collectors.toList());
    }
}

