/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.cluster;

import com.github.joschi.jadconfig.util.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.cluster.ClusterAdapter;
import org.graylog2.indexer.cluster.PendingTasksStats;
import org.graylog2.indexer.cluster.health.ClusterAllocationDiskSettings;
import org.graylog2.indexer.cluster.health.NodeDiskUsageStats;
import org.graylog2.indexer.cluster.health.NodeFileDescriptorStats;
import org.graylog2.indexer.indices.HealthStatus;
import org.graylog2.system.stats.elasticsearch.ClusterHealth;
import org.graylog2.system.stats.elasticsearch.ClusterStats;
import org.graylog2.system.stats.elasticsearch.ElasticsearchStats;
import org.graylog2.system.stats.elasticsearch.ShardStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Cluster {
    private static final Logger LOG = LoggerFactory.getLogger(Cluster.class);
    private final IndexSetRegistry indexSetRegistry;
    private final ScheduledExecutorService scheduler;
    private final Duration requestTimeout;
    private final ClusterAdapter clusterAdapter;

    @Inject
    public Cluster(IndexSetRegistry indexSetRegistry, @Named(value="daemonScheduler") ScheduledExecutorService scheduler, @Named(value="elasticsearch_socket_timeout") Duration requestTimeout, ClusterAdapter clusterAdapter) {
        this.scheduler = scheduler;
        this.indexSetRegistry = indexSetRegistry;
        this.requestTimeout = requestTimeout;
        this.clusterAdapter = clusterAdapter;
    }

    public Optional<HealthStatus> health() {
        return this.clusterAdapter.health();
    }

    private List<String> allIndexWildcards() {
        return Arrays.asList(this.indexSetRegistry.getIndexWildcards());
    }

    public Optional<HealthStatus> deflectorHealth() {
        return this.clusterAdapter.deflectorHealth(Arrays.asList(this.indexSetRegistry.getWriteIndexAliases()));
    }

    public Set<NodeFileDescriptorStats> getFileDescriptorStats() {
        return this.clusterAdapter.fileDescriptorStats();
    }

    public Set<NodeDiskUsageStats> getDiskUsageStats() {
        return this.clusterAdapter.diskUsageStats();
    }

    public ClusterAllocationDiskSettings getClusterAllocationDiskSettings() {
        return this.clusterAdapter.clusterAllocationDiskSettings();
    }

    public Optional<String> nodeIdToName(String nodeId) {
        return this.clusterAdapter.nodeIdToName(nodeId);
    }

    public Optional<String> nodeIdToHostName(String nodeId) {
        return this.clusterAdapter.nodeIdToHostName(nodeId);
    }

    public boolean isConnected() {
        return this.clusterAdapter.isConnected();
    }

    public boolean isHealthy() {
        return this.health().map(health -> !health.equals((Object)HealthStatus.Red) && this.indexSetRegistryIsUp()).orElse(false);
    }

    public boolean indexSetRegistryIsUp() {
        return this.indexSetRegistry.isUp();
    }

    public boolean isDeflectorHealthy() {
        return this.deflectorHealth().map(health -> !health.equals((Object)HealthStatus.Red) && this.indexSetRegistryIsUp()).orElse(false);
    }

    public void waitForConnectedAndDeflectorHealthy(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        LOG.debug("Waiting until the write-active index is healthy again, checking once per second.");
        CountDownLatch latch = new CountDownLatch(1);
        ScheduledFuture<?> scheduledFuture = this.scheduler.scheduleAtFixedRate(() -> {
            try {
                if (this.isConnected() && this.isDeflectorHealthy()) {
                    LOG.debug("Write-active index is healthy again, unblocking waiting threads.");
                    latch.countDown();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, 0L, 1L, TimeUnit.SECONDS);
        boolean waitSuccess = latch.await(timeout, unit);
        scheduledFuture.cancel(true);
        if (!waitSuccess) {
            throw new TimeoutException("Write-active index didn't get healthy within timeout");
        }
    }

    public void waitForConnectedAndDeflectorHealthy() throws InterruptedException, TimeoutException {
        this.waitForConnectedAndDeflectorHealthy(this.requestTimeout.getQuantity(), this.requestTimeout.getUnit());
    }

    public Optional<String> clusterName() {
        return this.clusterAdapter.clusterName();
    }

    public Optional<org.graylog2.rest.models.system.indexer.responses.ClusterHealth> clusterHealthStats() {
        return this.clusterAdapter.clusterHealthStats();
    }

    public ElasticsearchStats elasticsearchStats() {
        ClusterStats clusterStats = this.clusterAdapter.clusterStats();
        PendingTasksStats pendingTasksStats = this.clusterAdapter.pendingTasks();
        ShardStats shardStats = this.clusterAdapter.shardStats();
        ClusterHealth clusterHealth = ClusterHealth.from(shardStats, pendingTasksStats);
        HealthStatus healthStatus = this.clusterAdapter.health().orElseThrow(() -> new IllegalStateException("Unable to retrieve cluster health."));
        return ElasticsearchStats.create(clusterStats.clusterName(), clusterStats.clusterVersion(), healthStatus, clusterHealth, clusterStats.nodesStats(), clusterStats.indicesStats());
    }
}

