/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.cluster.leader.LeaderElectionService;
import org.graylog2.configuration.HttpConfiguration;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class NodePingThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(NodePingThread.class);
    private final NodeService nodeService;
    private final HttpConfiguration httpConfiguration;
    private final ServerStatus serverStatus;
    private final LeaderElectionService leaderElectionService;

    @Inject
    public NodePingThread(NodeService nodeService, HttpConfiguration httpConfiguration, ServerStatus serverStatus, LeaderElectionService leaderElectionService) {
        this.nodeService = nodeService;
        this.httpConfiguration = httpConfiguration;
        this.serverStatus = serverStatus;
        this.leaderElectionService = leaderElectionService;
    }

    @Override
    public synchronized void doRun() {
        boolean isLeader = this.leaderElectionService.isLeader();
        try {
            this.nodeService.markAsAlive(this.serverStatus.getNodeId(), isLeader, this.httpConfiguration.getHttpPublishUri().resolve("api/"));
        }
        catch (NodeNotFoundException e) {
            LOG.warn("Did not find meta info of this node. Re-registering.");
            this.nodeService.registerServer(this.serverStatus.getNodeId().toString(), isLeader, this.httpConfiguration.getHttpPublishUri().resolve("api/"), Tools.getLocalCanonicalHostname());
        }
        try {
            this.nodeService.dropOutdated();
        }
        catch (Exception e) {
            LOG.warn("Caught exception during node ping.", (Throwable)e);
        }
    }

    @Override
    @Nonnull
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return false;
    }

    @Override
    public boolean leaderOnly() {
        return false;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 1;
    }
}

