/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.validate.ClusterConfigValidatorService;
import org.graylog2.plugin.validate.ConfigValidationException;
import org.graylog2.rest.models.system.config.ClusterConfigList;
import org.graylog2.shared.plugins.ChainingClassLoader;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="System/ClusterConfig", description="Graylog Cluster Configuration")
@RequiresAuthentication
@Path(value="/system/cluster_config")
@Produces(value={"application/json"})
public class ClusterConfigResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterConfigResource.class);
    public static final String NO_CLASS_MSG = "Couldn't find configuration class  '%s'";
    private final ClusterConfigService clusterConfigService;
    private final ChainingClassLoader chainingClassLoader;
    private final ObjectMapper objectMapper;
    private final ClusterConfigValidatorService clusterConfigValidatorService;

    @Inject
    public ClusterConfigResource(ClusterConfigService clusterConfigService, ChainingClassLoader chainingClassLoader, ObjectMapper objectMapper, ClusterConfigValidatorService clusterConfigValidatorService) {
        this.clusterConfigService = Objects.requireNonNull(clusterConfigService);
        this.chainingClassLoader = chainingClassLoader;
        this.objectMapper = objectMapper;
        this.clusterConfigValidatorService = clusterConfigValidatorService;
    }

    @GET
    @ApiOperation(value="List all configuration classes")
    @Timed
    @RequiresPermissions(value={"clusterconfigentry:read"})
    public ClusterConfigList list() {
        Set<Class<?>> classes = this.clusterConfigService.list();
        return ClusterConfigList.createFromClass(classes);
    }

    @GET
    @Path(value="{configClass}")
    @ApiOperation(value="Get configuration settings from database")
    @Timed
    @RequiresPermissions(value={"clusterconfigentry:read"})
    public Object read(@ApiParam(name="configClass", value="The name of the cluster configuration class", required=true) @PathParam(value="configClass") @NotBlank String configClass) {
        Class<?> cls = this.classFromName(configClass);
        if (cls == null) {
            String error = ClusterConfigResource.createNoClassMsg(configClass);
            throw new NotFoundException(error);
        }
        return this.clusterConfigService.get(cls);
    }

    @PUT
    @Timed
    @Path(value="{configClass}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update configuration in database")
    @RequiresPermissions(value={"clusterconfigentry:create", "clusterconfigentry:edit"})
    @AuditEvent(type="server:cluster_configuration:update")
    public Response update(@ApiParam(name="configClass", value="The name of the cluster configuration class", required=true) @PathParam(value="configClass") @NotBlank String configClass, @ApiParam(name="body", value="The payload of the cluster configuration", required=true) @NotNull InputStream body) throws IOException {
        Class<?> cls = this.classFromName(configClass);
        if (cls == null) {
            throw new NotFoundException(ClusterConfigResource.createNoClassMsg(configClass));
        }
        Object configObject = this.parseConfigObject(configClass, body, cls);
        this.validateConfigObject(configObject);
        this.writeConfigObject(configClass, configObject);
        return Response.accepted((Object)configObject).build();
    }

    private void writeConfigObject(String configClass, Object configObject) {
        try {
            this.clusterConfigService.write(configObject);
        }
        catch (Exception e) {
            String msg = "Couldn't write cluster config \"" + configClass + "\".";
            LOG.error(msg, (Throwable)e);
            throw new InternalServerErrorException(msg, (Throwable)e);
        }
    }

    private void validateConfigObject(Object configObject) {
        try {
            this.clusterConfigValidatorService.validate(configObject);
        }
        catch (ConfigValidationException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    private Object parseConfigObject(String configClass, InputStream body, Class<?> cls) {
        Object object;
        try {
            object = this.objectMapper.readValue(body, cls);
        }
        catch (Exception e) {
            String msg = "Couldn't parse cluster configuration \"" + configClass + "\". The problem was : " + e.getMessage();
            LOG.error(msg, (Throwable)e);
            throw new BadRequestException(msg);
        }
        return object;
    }

    @DELETE
    @Path(value="{configClass}")
    @ApiOperation(value="Delete configuration settings from database")
    @Timed
    @RequiresPermissions(value={"clusterconfigentry:delete"})
    @AuditEvent(type="server:cluster_configuration:delete")
    public void delete(@ApiParam(name="configClass", value="The name of the cluster configuration class", required=true) @PathParam(value="configClass") @NotBlank String configClass) {
        Class<?> cls = this.classFromName(configClass);
        if (cls == null) {
            throw new NotFoundException(ClusterConfigResource.createNoClassMsg(configClass));
        }
        this.clusterConfigService.remove(cls);
    }

    @GET
    @Path(value="{configClass}")
    @Produces(value={"application/schema+json"})
    @ApiOperation(value="Get JSON schema of configuration class")
    @Timed
    @RequiresPermissions(value={"clusterconfigentry:read"})
    public JsonSchema schema(@ApiParam(name="configClass", value="The name of the cluster configuration class", required=true) @PathParam(value="configClass") @NotBlank String configClass) {
        Class<?> cls = this.classFromName(configClass);
        if (cls == null) {
            throw new NotFoundException(ClusterConfigResource.createNoClassMsg(configClass));
        }
        SchemaFactoryWrapper visitor = new SchemaFactoryWrapper();
        try {
            this.objectMapper.acceptJsonFormatVisitor(this.objectMapper.constructType(cls), (JsonFormatVisitorWrapper)visitor);
        }
        catch (JsonMappingException e) {
            throw new InternalServerErrorException("Couldn't generate JSON schema for configuration class " + configClass, (Throwable)e);
        }
        return visitor.finalSchema();
    }

    @Nullable
    private Class<?> classFromName(String className) {
        try {
            return this.chainingClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static String createNoClassMsg(String configClass) {
        return String.format(Locale.ENGLISH, NO_CLASS_MSG, configClass);
    }
}

