/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.system.stats.StatsService;
import org.graylog2.shared.system.stats.SystemStats;
import org.graylog2.shared.system.stats.fs.FsStats;
import org.graylog2.shared.system.stats.jvm.JvmStats;
import org.graylog2.shared.system.stats.network.NetworkStats;
import org.graylog2.shared.system.stats.os.OsStats;
import org.graylog2.shared.system.stats.process.ProcessStats;

@Api(value="System/Stats", description="Node system stats")
@Path(value="/system/stats")
@Produces(value={"application/json"})
@RequiresAuthentication
public class StatsResource
extends RestResource {
    private final StatsService statsService;

    @Inject
    public StatsResource(StatsService statsService) {
        this.statsService = statsService;
    }

    @GET
    @Timed
    @ApiOperation(value="System information about this node.", notes="This resource returns information about the system this node is running on.")
    public SystemStats systemStats() {
        return this.statsService.systemStatsWithoutNetwork();
    }

    @GET
    @Path(value="/fs")
    @Timed
    @ApiOperation(value="Filesystem information about this node.", notes="This resource returns information about the filesystems of this node.")
    public FsStats fsStats() {
        return this.statsService.fsStats();
    }

    @GET
    @Path(value="/jvm")
    @Timed
    @ApiOperation(value="JVM information about this node.", notes="This resource returns information about the Java Virtual Machine of this node.")
    public JvmStats jvmStats() {
        return this.statsService.jvmStats();
    }

    @GET
    @Path(value="/network")
    @Timed
    @ApiOperation(value="Networking information about this node.", notes="This resource returns information about the networking system this node is running with.")
    public NetworkStats networkStats() {
        return this.statsService.networkStats();
    }

    @GET
    @Path(value="/os")
    @Timed
    @ApiOperation(value="OS information about this node.", notes="This resource returns information about the operating system this node is running on.")
    public OsStats osStats() {
        return this.statsService.osStats();
    }

    @GET
    @Path(value="/process")
    @Timed
    @ApiOperation(value="Process information about this node.", notes="This resource returns information about the process this node is running as.")
    public ProcessStats processStats() {
        return this.statsService.processStats();
    }
}

