/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.buffers;

import com.lmax.disruptor.ExceptionHandler;
import org.slf4j.Logger;

public class LoggingExceptionHandler
implements ExceptionHandler<Object> {
    private final Logger logger;

    public LoggingExceptionHandler(Logger logger) {
        this.logger = logger;
    }

    public void handleEventException(Throwable ex, long sequence, Object event) {
        String eventStr;
        try {
            eventStr = event.toString();
        }
        catch (Exception e) {
            eventStr = "<invalid>";
        }
        this.logger.warn("Unable to process event " + eventStr + ", sequence " + sequence, ex);
    }

    public void handleOnStartException(Throwable ex) {
        this.logger.error("Exception occurred while starting disruptor.", ex);
    }

    public void handleOnShutdownException(Throwable ex) {
        this.logger.error("Exception occurred while stopping disruptor.", ex);
    }
}

