/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.fields;

import com.google.auto.value.AutoValue;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import java.util.Optional;
import org.graylog.events.fields.AutoValue_FieldValue;
import org.graylog.events.fields.FieldValueType;

@AutoValue
public abstract class FieldValue {
    public abstract FieldValueType dataType();

    public abstract String value();

    public static FieldValue create(FieldValueType dataType, String value) {
        return FieldValue.builder().dataType(dataType).value(value).build();
    }

    public static FieldValue error() {
        return FieldValue.create(FieldValueType.ERROR, "");
    }

    public static FieldValue string(String value) {
        return FieldValue.create(FieldValueType.STRING, value);
    }

    public Optional<Long> longValue(String value) {
        if (this.dataType().validate(value).isPresent()) {
            return Optional.empty();
        }
        return Optional.ofNullable(Longs.tryParse((String)value));
    }

    public Optional<Double> doubleValue(String value) {
        if (this.dataType().validate(value).isPresent()) {
            return Optional.empty();
        }
        return Optional.ofNullable(Doubles.tryParse((String)value));
    }

    public Optional<Boolean> booleanValue(String value) {
        if (this.dataType().validate(value).isPresent()) {
            return Optional.empty();
        }
        return Optional.of(Boolean.valueOf(value));
    }

    public boolean isError() {
        return this.dataType().isError();
    }

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public static Builder create() {
            return new AutoValue_FieldValue.Builder();
        }

        public abstract Builder dataType(FieldValueType var1);

        public abstract Builder value(String var1);

        public abstract FieldValue build();
    }
}

