/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor.aggregation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog.events.processor.aggregation.AggregationConditions;
import org.graylog.events.processor.aggregation.AggregationEventProcessorConfig;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;

final class AutoValue_AggregationEventProcessorConfig
extends AggregationEventProcessorConfig {
    private final String type;
    private final String query;
    private final ImmutableSet<Parameter> queryParameters;
    private final ImmutableSet<String> streams;
    private final List<String> groupBy;
    private final List<SeriesSpec> series;
    private final Optional<AggregationConditions> conditions;
    private final long searchWithinMs;
    private final long executeEveryMs;
    private final int eventLimit;

    private AutoValue_AggregationEventProcessorConfig(String type, String query, ImmutableSet<Parameter> queryParameters, ImmutableSet<String> streams, List<String> groupBy, List<SeriesSpec> series, Optional<AggregationConditions> conditions, long searchWithinMs, long executeEveryMs, int eventLimit) {
        this.type = type;
        this.query = query;
        this.queryParameters = queryParameters;
        this.streams = streams;
        this.groupBy = groupBy;
        this.series = series;
        this.conditions = conditions;
        this.searchWithinMs = searchWithinMs;
        this.executeEveryMs = executeEveryMs;
        this.eventLimit = eventLimit;
    }

    @Override
    @JsonProperty(value="type")
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="query")
    public String query() {
        return this.query;
    }

    @Override
    @JsonProperty(value="query_parameters")
    public ImmutableSet<Parameter> queryParameters() {
        return this.queryParameters;
    }

    @Override
    @JsonProperty(value="streams")
    public ImmutableSet<String> streams() {
        return this.streams;
    }

    @Override
    @JsonProperty(value="group_by")
    public List<String> groupBy() {
        return this.groupBy;
    }

    @Override
    @JsonProperty(value="series")
    public List<SeriesSpec> series() {
        return this.series;
    }

    @Override
    @JsonProperty(value="conditions")
    public Optional<AggregationConditions> conditions() {
        return this.conditions;
    }

    @Override
    @JsonProperty(value="search_within_ms")
    public long searchWithinMs() {
        return this.searchWithinMs;
    }

    @Override
    @JsonProperty(value="execute_every_ms")
    public long executeEveryMs() {
        return this.executeEveryMs;
    }

    @Override
    @JsonProperty(value="event_limit")
    public int eventLimit() {
        return this.eventLimit;
    }

    public String toString() {
        return "AggregationEventProcessorConfig{type=" + this.type + ", query=" + this.query + ", queryParameters=" + this.queryParameters + ", streams=" + this.streams + ", groupBy=" + this.groupBy + ", series=" + this.series + ", conditions=" + this.conditions + ", searchWithinMs=" + this.searchWithinMs + ", executeEveryMs=" + this.executeEveryMs + ", eventLimit=" + this.eventLimit + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AggregationEventProcessorConfig) {
            AggregationEventProcessorConfig that = (AggregationEventProcessorConfig)o;
            return this.type.equals(that.type()) && this.query.equals(that.query()) && this.queryParameters.equals(that.queryParameters()) && this.streams.equals(that.streams()) && this.groupBy.equals(that.groupBy()) && this.series.equals(that.series()) && this.conditions.equals(that.conditions()) && this.searchWithinMs == that.searchWithinMs() && this.executeEveryMs == that.executeEveryMs() && this.eventLimit == that.eventLimit();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.type.hashCode();
        h$ *= 1000003;
        h$ ^= this.query.hashCode();
        h$ *= 1000003;
        h$ ^= this.queryParameters.hashCode();
        h$ *= 1000003;
        h$ ^= this.streams.hashCode();
        h$ *= 1000003;
        h$ ^= this.groupBy.hashCode();
        h$ *= 1000003;
        h$ ^= this.series.hashCode();
        h$ *= 1000003;
        h$ ^= this.conditions.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.searchWithinMs >>> 32 ^ this.searchWithinMs);
        h$ *= 1000003;
        h$ ^= (int)(this.executeEveryMs >>> 32 ^ this.executeEveryMs);
        h$ *= 1000003;
        return h$ ^= this.eventLimit;
    }

    @Override
    public AggregationEventProcessorConfig.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends AggregationEventProcessorConfig.Builder {
        private String type;
        private String query;
        private ImmutableSet<Parameter> queryParameters;
        private ImmutableSet<String> streams;
        private List<String> groupBy;
        private List<SeriesSpec> series;
        private Optional<AggregationConditions> conditions = Optional.empty();
        private long searchWithinMs;
        private long executeEveryMs;
        private int eventLimit;
        private byte set$0;

        Builder() {
        }

        private Builder(AggregationEventProcessorConfig source) {
            this.type = source.type();
            this.query = source.query();
            this.queryParameters = source.queryParameters();
            this.streams = source.streams();
            this.groupBy = source.groupBy();
            this.series = source.series();
            this.conditions = source.conditions();
            this.searchWithinMs = source.searchWithinMs();
            this.executeEveryMs = source.executeEveryMs();
            this.eventLimit = source.eventLimit();
            this.set$0 = (byte)7;
        }

        @Override
        public AggregationEventProcessorConfig.Builder type(String type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public AggregationEventProcessorConfig.Builder query(String query) {
            if (query == null) {
                throw new NullPointerException("Null query");
            }
            this.query = query;
            return this;
        }

        @Override
        public AggregationEventProcessorConfig.Builder queryParameters(Set<Parameter> queryParameters) {
            this.queryParameters = ImmutableSet.copyOf(queryParameters);
            return this;
        }

        @Override
        public AggregationEventProcessorConfig.Builder streams(Set<String> streams) {
            this.streams = ImmutableSet.copyOf(streams);
            return this;
        }

        @Override
        public AggregationEventProcessorConfig.Builder groupBy(List<String> groupBy) {
            if (groupBy == null) {
                throw new NullPointerException("Null groupBy");
            }
            this.groupBy = groupBy;
            return this;
        }

        @Override
        public AggregationEventProcessorConfig.Builder series(List<SeriesSpec> series) {
            if (series == null) {
                throw new NullPointerException("Null series");
            }
            this.series = series;
            return this;
        }

        @Override
        public AggregationEventProcessorConfig.Builder conditions(@Nullable AggregationConditions conditions) {
            this.conditions = Optional.ofNullable(conditions);
            return this;
        }

        @Override
        public AggregationEventProcessorConfig.Builder searchWithinMs(long searchWithinMs) {
            this.searchWithinMs = searchWithinMs;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public AggregationEventProcessorConfig.Builder executeEveryMs(long executeEveryMs) {
            this.executeEveryMs = executeEveryMs;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        public AggregationEventProcessorConfig.Builder eventLimit(Integer eventLimit) {
            if (eventLimit == null) {
                throw new NullPointerException("Null eventLimit");
            }
            this.eventLimit = eventLimit;
            this.set$0 = (byte)(this.set$0 | 4);
            return this;
        }

        @Override
        public AggregationEventProcessorConfig build() {
            if (this.set$0 != 7 || this.type == null || this.query == null || this.queryParameters == null || this.streams == null || this.groupBy == null || this.series == null) {
                StringBuilder missing = new StringBuilder();
                if (this.type == null) {
                    missing.append(" type");
                }
                if (this.query == null) {
                    missing.append(" query");
                }
                if (this.queryParameters == null) {
                    missing.append(" queryParameters");
                }
                if (this.streams == null) {
                    missing.append(" streams");
                }
                if (this.groupBy == null) {
                    missing.append(" groupBy");
                }
                if (this.series == null) {
                    missing.append(" series");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" searchWithinMs");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" executeEveryMs");
                }
                if ((this.set$0 & 4) == 0) {
                    missing.append(" eventLimit");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AggregationEventProcessorConfig(this.type, this.query, this.queryParameters, this.streams, this.groupBy, this.series, this.conditions, this.searchWithinMs, this.executeEveryMs, this.eventLimit);
        }
    }
}

