/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.aws.transports;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.integrations.aws.AWSMessageType;
import org.graylog.integrations.aws.cloudwatch.CloudWatchLogSubscriptionData;
import org.graylog.integrations.aws.cloudwatch.KinesisLogEntry;
import org.graylog2.plugin.Tools;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KinesisPayloadDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisPayloadDecoder.class);
    private final ObjectMapper objectMapper;
    private final AWSMessageType awsMessageType;
    private final String kinesisStream;

    @Inject
    public KinesisPayloadDecoder(ObjectMapper objectMapper, AWSMessageType awsMessageType, String kinesisStream) {
        this.objectMapper = objectMapper;
        this.awsMessageType = awsMessageType;
        this.kinesisStream = kinesisStream;
    }

    List<KinesisLogEntry> processMessages(byte[] payloadBytes, Instant approximateArrivalTimestamp) throws IOException {
        if (this.awsMessageType == AWSMessageType.KINESIS_CLOUDWATCH_FLOW_LOGS || this.awsMessageType == AWSMessageType.KINESIS_CLOUDWATCH_RAW) {
            CloudWatchLogSubscriptionData logSubscriptionData = KinesisPayloadDecoder.decompressCloudWatchMessages(payloadBytes, this.objectMapper);
            return logSubscriptionData.logEvents().stream().map(le -> {
                DateTime timestamp = new DateTime(le.timestamp(), DateTimeZone.UTC);
                return KinesisLogEntry.create(this.kinesisStream, logSubscriptionData.logGroup(), logSubscriptionData.logStream(), timestamp, le.message());
            }).collect(Collectors.toList());
        }
        if (this.awsMessageType == AWSMessageType.KINESIS_RAW) {
            DateTime timestamp = new DateTime(approximateArrivalTimestamp.toEpochMilli(), DateTimeZone.UTC);
            KinesisLogEntry kinesisLogEntry = KinesisLogEntry.create(this.kinesisStream, "", "", timestamp, new String(payloadBytes, StandardCharsets.UTF_8));
            return Collections.singletonList(kinesisLogEntry);
        }
        LOG.error("The AWSMessageType [{}] is not supported by the KinesisTransport", (Object)this.awsMessageType);
        return new ArrayList<KinesisLogEntry>();
    }

    public static CloudWatchLogSubscriptionData decompressCloudWatchMessages(byte[] payloadBytes, ObjectMapper objectMapper) throws IOException {
        LOG.debug("The supplied payload is GZip compressed. Proceeding to decompress and parse as a CloudWatch log message.");
        byte[] bytes = Tools.decompressGzip(payloadBytes).getBytes(StandardCharsets.UTF_8);
        LOG.debug("They payload was decompressed successfully. size [{}]", (Object)bytes.length);
        CloudWatchLogSubscriptionData logSubscriptionData = (CloudWatchLogSubscriptionData)objectMapper.readValue(bytes, CloudWatchLogSubscriptionData.class);
        if (LOG.isTraceEnabled()) {
            LOG.trace("[{}] messages obtained from CloudWatch", (Object)logSubscriptionData.logEvents().size());
        }
        return logSubscriptionData;
    }
}

