/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.inputs.paloalto;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang.StringUtils;
import org.graylog.integrations.inputs.paloalto.PaloAltoMessageBase;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaloAltoParser {
    private static final Logger LOG = LoggerFactory.getLogger(PaloAltoParser.class);
    private static final DateTimeFormatter SYSLOG_TIMESTAMP_FORMATTER = DateTimeFormat.forPattern((String)"MMM d HH:mm:ss YYYY").withLocale(Locale.US);
    private static final Pattern PANORAMA_SYSLOG_PARSER = Pattern.compile("<\\d+>[0-9] (.+?) (.+?)\\s[-]\\s[-]\\s[-]\\s[-]\\s(\\d,.*)");
    private static final Pattern STANDARD_SYSLOG_PARSER = Pattern.compile("<\\d+>([A-Z][a-z][a-z]\\s{1,2}\\d{1,2}\\s\\d{1,2}[:]\\d{1,2}[:]\\d{2})\\s(.+?)\\s(\\d,.*)");
    private static final Pattern STANDARD_SYSLOG_NO_HOST_PARSER = Pattern.compile("<\\d+>([A-Z][a-z][a-z]\\s{1,2}\\d{1,2}\\s\\d{1,2}[:]\\d{1,2}[:]\\d{2})\\s(\\d,.*)");
    private static final String SINGLE_SPACE = " ";
    private static final String DOUBLE_SPACE = "\\s{2}";

    @Nullable
    public PaloAltoMessageBase parse(@NotNull String raw, DateTimeZone timezone) {
        if (PANORAMA_SYSLOG_PARSER.matcher(raw = StringUtils.trim((String)raw)).matches()) {
            LOG.trace("Message is in Panorama format [{}]", (Object)raw);
            Matcher matcher = PANORAMA_SYSLOG_PARSER.matcher(raw);
            if (matcher.find()) {
                String timestampString = matcher.group(1);
                String source = matcher.group(2);
                String fieldsString = matcher.group(3);
                DateTime timestamp = timestampString.substring(timestampString.length() - 6).matches(".*[Z+-].*") ? DateTime.parse((String)timestampString) : DateTime.parse((String)timestampString, (DateTimeFormatter)ISODateTimeFormat.dateTimeParser().withZone(timezone));
                return this.buildPaloAltoMessageBase(timestamp, fieldsString, source);
            }
            LOG.error("Cannot parse malformed Panorama message: {}", (Object)raw);
            return null;
        }
        if (STANDARD_SYSLOG_PARSER.matcher(raw).matches()) {
            LOG.trace("Message is in structured syslog format [{}]", (Object)raw);
            Matcher matcher = STANDARD_SYSLOG_PARSER.matcher(raw);
            if (matcher.matches()) {
                String dateWithoutYear = matcher.group(1).replaceFirst(DOUBLE_SPACE, SINGLE_SPACE);
                DateTime timestamp = SYSLOG_TIMESTAMP_FORMATTER.withZone(timezone).parseDateTime(dateWithoutYear + SINGLE_SPACE + DateTime.now((DateTimeZone)DateTimeZone.UTC).getYear());
                String source = matcher.group(2);
                String panData = matcher.group(3);
                return this.buildPaloAltoMessageBase(timestamp, panData, source);
            }
            LOG.error("Cannot parse malformed Syslog message: {}", (Object)raw);
            return null;
        }
        if (STANDARD_SYSLOG_NO_HOST_PARSER.matcher(raw).matches()) {
            LOG.trace("Message is in structured syslog (with no hostname) format [{}]", (Object)raw);
            Matcher matcher = STANDARD_SYSLOG_NO_HOST_PARSER.matcher(raw);
            if (matcher.matches()) {
                String dateWithoutYear = matcher.group(1).replaceFirst(DOUBLE_SPACE, SINGLE_SPACE);
                DateTime timestamp = SYSLOG_TIMESTAMP_FORMATTER.parseDateTime(dateWithoutYear + SINGLE_SPACE + DateTime.now((DateTimeZone)DateTimeZone.UTC).getYear()).withZone(timezone);
                String panData = matcher.group(2);
                return this.buildPaloAltoMessageBase(timestamp, panData, "");
            }
            LOG.error("Cannot parse malformed Syslog message: {}", (Object)raw);
            return null;
        }
        LOG.error("Cannot parse malformed PAN message [unrecognized format]: {}", (Object)raw);
        return null;
    }

    private PaloAltoMessageBase buildPaloAltoMessageBase(DateTime timestamp, String messagePayload, String source) {
        ImmutableList<String> fields = this.parseCSVFields(messagePayload);
        if (fields == null) {
            return null;
        }
        return PaloAltoMessageBase.create(source, timestamp, messagePayload, (String)fields.get(3), fields);
    }

    private ImmutableList<String> parseCSVFields(String messagePayload) {
        StringReader stringReader = new StringReader(messagePayload);
        List csvRecords = null;
        try {
            csvRecords = new CSVParser((Reader)stringReader, CSVFormat.DEFAULT).getRecords();
        }
        catch (IOException e) {
            LOG.error("Cannot parse CSV PAN message: {}", (Object)messagePayload, (Object)e);
            return null;
        }
        if (csvRecords.size() != 1) {
            LOG.error("Cannot parse malformed/multiline Syslog message: {}", (Object)messagePayload);
            return null;
        }
        ArrayList fieldValues = Lists.newArrayList((Iterator)((CSVRecord)csvRecords.get(0)).iterator());
        return ImmutableList.copyOf((Collection)fieldValues);
    }
}

