/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.conversion;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;

public class DoubleConversion
extends AbstractFunction<Double> {
    public static final String NAME = "to_double";
    private static final String VALUE = "value";
    private static final String DEFAULT = "default";
    private final ParameterDescriptor<Object, Object> valueParam = ParameterDescriptor.object("value").ruleBuilderVariable().description("Value to convert").build();
    private final ParameterDescriptor<Double, Double> defaultParam = ParameterDescriptor.floating("default").optional().allowNegatives(true).description("Used when 'value' is null, defaults to 0").build();

    @Override
    public Double evaluate(FunctionArgs args, EvaluationContext context) {
        Object evaluated = this.valueParam.required(args, context);
        Double defaultValue = this.defaultParam.optional(args, context).orElse(0.0);
        if (evaluated == null) {
            return defaultValue;
        }
        if (evaluated instanceof Number) {
            return ((Number)evaluated).doubleValue();
        }
        String s = String.valueOf(evaluated);
        return (Double)MoreObjects.firstNonNull((Object)Doubles.tryParse((String)s), (Object)defaultValue);
    }

    @Override
    public FunctionDescriptor<Double> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Double.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.valueParam, this.defaultParam)).description("Converts a value to a double value using its string representation").ruleBuilderEnabled().ruleBuilderName("Convert to double").ruleBuilderTitle("Convert '${value}' to double").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.CONVERSION).build();
    }
}

