/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.strings;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import org.apache.commons.lang3.StringUtils;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;

public class Replace
extends AbstractFunction<String> {
    public static final String NAME = "replace";
    private final ParameterDescriptor<String, String> valueParam = ParameterDescriptor.string("value").ruleBuilderVariable().description("The text to search and replace in").build();
    private final ParameterDescriptor<String, String> searchParam = ParameterDescriptor.string("search").description("The string to search for").build();
    private final ParameterDescriptor<String, String> replacementParam = ParameterDescriptor.string("replacement").optional().description("The string to replace it with. Default: \"\"").build();
    private final ParameterDescriptor<Long, Integer> maxParam = ParameterDescriptor.integer("max", Integer.class).optional().transform(Ints::saturatedCast).description("Maximum number of occurrences to replace, or -1 if no maximum. Default: -1").build();

    @Override
    public String evaluate(FunctionArgs args, EvaluationContext context) {
        String text = this.valueParam.required(args, context);
        String searchString = this.searchParam.required(args, context);
        String replacement = this.replacementParam.optional(args, context).orElse("");
        int max = this.maxParam.optional(args, context).orElse(-1);
        return StringUtils.replace((String)text, (String)searchString, (String)replacement, (int)max);
    }

    @Override
    public FunctionDescriptor<String> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(String.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.valueParam, this.searchParam, this.replacementParam, this.maxParam)).description("Replaces the first \"max\" or all occurrences of a string within another string").ruleBuilderEnabled().ruleBuilderName("Replace in string").ruleBuilderTitle("Replace <#if max??>the first ${max} <#else>all </#if>occurrences of '${search}' within '${value}' with '${replacement!''}'").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.STRING).build();
    }
}

