/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.response.decorators;

import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.scriptingapi.request.RequestedField;
import org.graylog.plugins.views.search.rest.scriptingapi.response.decorators.FieldDecorator;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;

public class NodeTitleDecorator
implements FieldDecorator {
    private final NodeService nodeService;

    @Inject
    public NodeTitleDecorator(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    public boolean accept(RequestedField field) {
        return "gl2_source_node".equals(field.name()) && this.acceptsDecorator(field.decorator());
    }

    private boolean acceptsDecorator(@Nullable String decorator) {
        return decorator == null || decorator.equals("title");
    }

    @Override
    public Object decorate(RequestedField field, Object value, SearchUser searchUser) {
        try {
            Node node = this.nodeService.byNodeId(value.toString());
            return node.getTitle();
        }
        catch (NodeNotFoundException e) {
            return value;
        }
    }
}

