/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.validation;

import java.util.Optional;
import org.graylog.plugins.views.search.engine.QueryPosition;
import org.graylog.plugins.views.search.validation.ValidationMessage;
import org.graylog.plugins.views.search.validation.ValidationStatus;
import org.graylog.plugins.views.search.validation.ValidationType;

final class AutoValue_ValidationMessage
extends ValidationMessage {
    private final Optional<QueryPosition> position;
    private final String errorMessage;
    private final Optional<String> relatedProperty;
    private final ValidationStatus validationStatus;
    private final ValidationType validationType;

    private AutoValue_ValidationMessage(Optional<QueryPosition> position, String errorMessage, Optional<String> relatedProperty, ValidationStatus validationStatus, ValidationType validationType) {
        this.position = position;
        this.errorMessage = errorMessage;
        this.relatedProperty = relatedProperty;
        this.validationStatus = validationStatus;
        this.validationType = validationType;
    }

    @Override
    public Optional<QueryPosition> position() {
        return this.position;
    }

    @Override
    public String errorMessage() {
        return this.errorMessage;
    }

    @Override
    public Optional<String> relatedProperty() {
        return this.relatedProperty;
    }

    @Override
    public ValidationStatus validationStatus() {
        return this.validationStatus;
    }

    @Override
    public ValidationType validationType() {
        return this.validationType;
    }

    public String toString() {
        return "ValidationMessage{position=" + this.position + ", errorMessage=" + this.errorMessage + ", relatedProperty=" + this.relatedProperty + ", validationStatus=" + this.validationStatus + ", validationType=" + this.validationType + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ValidationMessage) {
            ValidationMessage that = (ValidationMessage)o;
            return this.position.equals(that.position()) && this.errorMessage.equals(that.errorMessage()) && this.relatedProperty.equals(that.relatedProperty()) && this.validationStatus.equals((Object)that.validationStatus()) && this.validationType.equals((Object)that.validationType());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.position.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorMessage.hashCode();
        h$ *= 1000003;
        h$ ^= this.relatedProperty.hashCode();
        h$ *= 1000003;
        h$ ^= this.validationStatus.hashCode();
        h$ *= 1000003;
        return h$ ^= this.validationType.hashCode();
    }

    @Override
    public ValidationMessage.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ValidationMessage.Builder {
        private Optional<QueryPosition> position = Optional.empty();
        private String errorMessage;
        private Optional<String> relatedProperty = Optional.empty();
        private ValidationStatus validationStatus;
        private ValidationType validationType;

        Builder() {
        }

        private Builder(ValidationMessage source) {
            this.position = source.position();
            this.errorMessage = source.errorMessage();
            this.relatedProperty = source.relatedProperty();
            this.validationStatus = source.validationStatus();
            this.validationType = source.validationType();
        }

        @Override
        public ValidationMessage.Builder position(QueryPosition position) {
            this.position = Optional.of(position);
            return this;
        }

        @Override
        public ValidationMessage.Builder errorMessage(String errorMessage) {
            if (errorMessage == null) {
                throw new NullPointerException("Null errorMessage");
            }
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public ValidationMessage.Builder relatedProperty(String relatedProperty) {
            this.relatedProperty = Optional.of(relatedProperty);
            return this;
        }

        @Override
        public ValidationMessage.Builder validationStatus(ValidationStatus validationStatus) {
            if (validationStatus == null) {
                throw new NullPointerException("Null validationStatus");
            }
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public ValidationMessage.Builder validationType(ValidationType validationType) {
            if (validationType == null) {
                throw new NullPointerException("Null validationType");
            }
            this.validationType = validationType;
            return this;
        }

        @Override
        public ValidationMessage build() {
            if (this.errorMessage == null || this.validationStatus == null || this.validationType == null) {
                StringBuilder missing = new StringBuilder();
                if (this.errorMessage == null) {
                    missing.append(" errorMessage");
                }
                if (this.validationStatus == null) {
                    missing.append(" validationStatus");
                }
                if (this.validationType == null) {
                    missing.append(" validationType");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ValidationMessage(this.position, this.errorMessage, this.relatedProperty, this.validationStatus, this.validationType);
        }
    }
}

