/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.validation;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.validation.AutoValue_ValidationRequest;
import org.graylog.plugins.views.search.validation.ValidationMode;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@AutoValue
public abstract class ValidationRequest {
    @NotNull
    public abstract BackendQuery query();

    @NotNull
    public abstract Optional<BackendQuery> filter();

    public String getCombinedQueryWithFilter() {
        ElasticsearchQueryString esQuery = (ElasticsearchQueryString)this.query();
        return this.filter().map(f -> (ElasticsearchQueryString)f).map(esQuery::concatenate).orElse(esQuery).queryString();
    }

    @NotNull
    public abstract TimeRange timerange();

    @NotNull
    public abstract Set<String> streams();

    @NotNull
    public abstract ImmutableSet<Parameter> parameters();

    @NotNull
    public abstract ValidationMode validationMode();

    public static Builder builder() {
        return new AutoValue_ValidationRequest.Builder().parameters((ImmutableSet<Parameter>)ImmutableSet.builder().build()).validationMode(ValidationMode.QUERY);
    }

    public boolean isEmptyQuery() {
        return StringUtils.isEmpty((CharSequence)this.query().queryString());
    }

    public String rawQuery() {
        return this.query().queryString();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder query(@NotNull BackendQuery var1);

        public abstract Builder filter(@Nullable BackendQuery var1);

        public abstract Builder streams(@NotNull Set<String> var1);

        public abstract Builder timerange(@NotNull TimeRange var1);

        public abstract Builder parameters(@NotNull ImmutableSet<Parameter> var1);

        public abstract ValidationRequest build();

        public static Builder builder() {
            return new AutoValue_ValidationRequest.Builder();
        }

        public abstract Builder validationMode(ValidationMode var1);
    }
}

