/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.graylog.security.certutil.CaConfiguration;
import org.graylog.security.certutil.CaService;
import org.graylog.security.certutil.CertificateAuthorityChangedEvent;
import org.graylog.security.certutil.ca.CAKeyPair;
import org.graylog.security.certutil.ca.PemCaReader;
import org.graylog.security.certutil.ca.exceptions.CACreationException;
import org.graylog.security.certutil.ca.exceptions.KeyStoreStorageException;
import org.graylog.security.certutil.keystore.storage.SmartKeystoreStorage;
import org.graylog.security.certutil.keystore.storage.location.KeystoreFileLocation;
import org.graylog.security.certutil.keystore.storage.location.KeystoreMongoCollections;
import org.graylog.security.certutil.keystore.storage.location.KeystoreMongoLocation;
import org.graylog2.Configuration;
import org.graylog2.bootstrap.preflight.web.resources.model.CA;
import org.graylog2.bootstrap.preflight.web.resources.model.CAType;
import org.graylog2.cluster.certificates.CertificatesService;
import org.graylog2.events.ClusterEventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CaServiceImpl
implements CaService {
    private static final Logger LOG = LoggerFactory.getLogger(CaServiceImpl.class);
    public final String KEYSTORE_ID = "GRAYLOG CA";
    private final SmartKeystoreStorage keystoreStorage;
    private final KeystoreMongoLocation mongoDbCaLocation;
    private final KeystoreFileLocation manuallyProvidedCALocation;
    private final PemCaReader pemCaReader;
    private final CaConfiguration configuration;
    private final CertificatesService certificatesService;
    private final String passwordSecret;
    private final ClusterEventBus eventBus;

    @Inject
    public CaServiceImpl(Configuration configuration, SmartKeystoreStorage keystoreStorage, PemCaReader pemCaReader, CertificatesService certificatesService, @Named(value="password_secret") String passwordSecret, ClusterEventBus eventBus) {
        this.keystoreStorage = keystoreStorage;
        this.pemCaReader = pemCaReader;
        this.configuration = configuration;
        this.certificatesService = certificatesService;
        this.passwordSecret = configuration.getCaPassword() != null ? configuration.getCaPassword() : passwordSecret;
        this.mongoDbCaLocation = new KeystoreMongoLocation("GRAYLOG CA", KeystoreMongoCollections.GRAYLOG_CA_KEYSTORE_COLLECTION);
        this.manuallyProvidedCALocation = new KeystoreFileLocation(configuration.getCaKeystoreFile());
        this.eventBus = eventBus;
    }

    @Override
    public CA get() throws KeyStoreStorageException {
        if (this.configuration.configuredCaExists()) {
            return new CA("local CA", CAType.LOCAL);
        }
        Optional<KeyStore> keystore = this.keystoreStorage.readKeyStore(this.mongoDbCaLocation, this.passwordSecret.toCharArray());
        return keystore.map(c -> new CA("GRAYLOG CA", CAType.GENERATED)).orElse(null);
    }

    @Override
    public void create(String organization, Integer daysValid, char[] password) throws CACreationException, KeyStoreStorageException, KeyStoreException {
        Duration certificateValidity = Duration.ofDays(daysValid == null || daysValid == 0 ? 3650L : (long)daysValid.intValue());
        KeyStore keyStore = CAKeyPair.create(organization, this.passwordSecret.toCharArray(), certificateValidity).toKeyStore();
        this.keystoreStorage.writeKeyStore(this.mongoDbCaLocation, keyStore, this.passwordSecret.toCharArray(), password);
        LOG.debug("Generated a new CA.");
        this.triggerCaChangedEvent();
    }

    @Override
    public void upload(@Nullable String password, List<FormDataBodyPart> parts) throws CACreationException {
        char[] passwordCharArray = password == null ? null : password.toCharArray();
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12", "BC");
            keyStore.load(null, null);
            for (BodyPart bodyPart : parts) {
                InputStream is = (InputStream)bodyPart.getEntityAs(InputStream.class);
                byte[] bytes = is.readAllBytes();
                String pem = new String(bytes, StandardCharsets.UTF_8);
                if (pem.contains("-----BEGIN CERTIFICATE")) {
                    PemCaReader.CA ca = this.pemCaReader.readCA(pem, password);
                    keyStore.setKeyEntry("ca", ca.privateKey(), passwordCharArray, ca.certificates().toArray(new Certificate[0]));
                    continue;
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                keyStore.load(bais, passwordCharArray);
            }
            this.keystoreStorage.writeKeyStore(this.mongoDbCaLocation, keyStore, passwordCharArray, this.passwordSecret.toCharArray());
            this.triggerCaChangedEvent();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException | KeyStoreStorageException ex) {
            LOG.error("Could not write CA: " + ex.getMessage(), (Throwable)ex);
            throw new CACreationException("Could not write CA: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void startOver() {
        this.certificatesService.removeCert(this.mongoDbCaLocation);
    }

    private void triggerCaChangedEvent() {
        this.eventBus.post(new CertificateAuthorityChangedEvent());
    }

    @Override
    public Optional<KeyStore> loadKeyStore() throws KeyStoreStorageException {
        if (this.configuration.configuredCaExists()) {
            return this.keystoreStorage.readKeyStore(this.manuallyProvidedCALocation, this.configuration.getCaPassword().toCharArray());
        }
        return this.keystoreStorage.readKeyStore(this.mongoDbCaLocation, this.passwordSecret.toCharArray());
    }
}

