/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil;

import com.google.common.util.concurrent.AbstractIdleService;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog.scheduler.DBCustomJobDefinitionService;
import org.graylog.scheduler.DBJobDefinitionService;
import org.graylog.scheduler.DBJobTriggerService;
import org.graylog.scheduler.JobDefinitionDto;
import org.graylog.scheduler.JobTriggerDto;
import org.graylog.scheduler.JobTriggerStatus;
import org.graylog.scheduler.schedule.CronJobSchedule;
import org.graylog.security.certutil.CheckForCertRenewalJob;

@Singleton
public class ConfigureCertRenewalJobOnStartupService
extends AbstractIdleService {
    private final DBJobDefinitionService jobDefinitionService;
    private final DBCustomJobDefinitionService customJobDefinitionService;
    private final DBJobTriggerService jobTriggerService;

    @Inject
    public ConfigureCertRenewalJobOnStartupService(DBJobDefinitionService jobDefinitionService, DBCustomJobDefinitionService customJobDefinitionService, DBJobTriggerService jobTriggerService) {
        this.jobDefinitionService = jobDefinitionService;
        this.customJobDefinitionService = customJobDefinitionService;
        this.jobTriggerService = jobTriggerService;
    }

    protected void startUp() throws Exception {
        if (this.jobDefinitionService.get("64a66741cb3275652764c937").isEmpty()) {
            JobDefinitionDto jobDefinition = this.customJobDefinitionService.findOrCreate(CheckForCertRenewalJob.DEFINITION_INSTANCE);
            CronJobSchedule cronJobSchedule = CronJobSchedule.builder().cronExpression("0 0,30 * * * ? *").build();
            JobTriggerDto trigger = JobTriggerDto.builder().jobDefinitionId(jobDefinition.id()).jobDefinitionType("check-for-cert-renewal-execution-v1").schedule(cronJobSchedule).status(JobTriggerStatus.RUNNABLE).build();
            this.jobTriggerService.create(trigger);
        }
    }

    protected void shutDown() throws Exception {
    }
}

