/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings.providers;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.time.ZonedDateTime;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.graylog.plugins.views.search.views.MongoIgnore;
import org.graylog2.jackson.MongoJodaDateTimeDeserializer;
import org.graylog2.jackson.MongoJodaDateTimeSerializer;
import org.graylog2.jackson.MongoZonedDateTimeDeserializer;
import org.graylog2.jackson.MongoZonedDateTimeSerializer;
import org.graylog2.security.encryption.EncryptedValueMapperConfig;
import org.joda.time.DateTime;

public class CommonMongoJackObjectMapperProvider
implements Provider<ObjectMapper> {
    private final Provider<ObjectMapper> objectMapperProvider;
    private static final BeanSerializerModifier customBeanSerializerModifier = new BeanSerializerModifier(){

        public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
            beanProperties.removeIf(prop -> prop.getAnnotation(MongoIgnore.class) != null);
            return beanProperties;
        }
    };
    private static final Module serializationModule = new SimpleModule("JSR-310-MongoJack").addSerializer(ZonedDateTime.class, (JsonSerializer)new MongoZonedDateTimeSerializer()).addDeserializer(ZonedDateTime.class, (JsonDeserializer)new MongoZonedDateTimeDeserializer()).addSerializer(DateTime.class, (JsonSerializer)new MongoJodaDateTimeSerializer()).addDeserializer(DateTime.class, (JsonDeserializer)new MongoJodaDateTimeDeserializer()).setSerializerModifier(customBeanSerializerModifier);

    @Inject
    public CommonMongoJackObjectMapperProvider(Provider<ObjectMapper> objectMapperProvider) {
        this.objectMapperProvider = objectMapperProvider;
    }

    public ObjectMapper get() {
        return CommonMongoJackObjectMapperProvider.configure((ObjectMapper)this.objectMapperProvider.get());
    }

    public static ObjectMapper configure(ObjectMapper objectMapper) {
        ObjectMapper configuredObjectMapper = objectMapper.copy().registerModule(serializationModule);
        EncryptedValueMapperConfig.enableDatabase(configuredObjectMapper);
        return configuredObjectMapper;
    }
}

