/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight.web.resources;

import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.graylog.security.certutil.CaService;
import org.graylog.security.certutil.ca.exceptions.CACreationException;
import org.graylog.security.certutil.ca.exceptions.KeyStoreStorageException;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.bootstrap.preflight.web.resources.model.CA;
import org.graylog2.bootstrap.preflight.web.resources.model.CertParameters;
import org.graylog2.bootstrap.preflight.web.resources.model.CreateCARequest;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeService;
import org.graylog2.cluster.preflight.DataNodeProvisioningConfig;
import org.graylog2.cluster.preflight.DataNodeProvisioningService;
import org.graylog2.plugin.certificates.RenewalPolicy;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.rest.ApiError;

@Path(value="/api/")
@Produces(value={"application/json"})
public class PreflightResource {
    private final NodeService nodeService;
    private final DataNodeProvisioningService dataNodeProvisioningService;
    private final CaService caService;
    private final ClusterConfigService clusterConfigService;
    private final String passwordSecret;

    @Inject
    public PreflightResource(NodeService nodeService, DataNodeProvisioningService dataNodeProvisioningService, CaService caService, ClusterConfigService clusterConfigService, @Named(value="password_secret") String passwordSecret) {
        this.nodeService = nodeService;
        this.dataNodeProvisioningService = dataNodeProvisioningService;
        this.caService = caService;
        this.clusterConfigService = clusterConfigService;
        this.passwordSecret = passwordSecret;
    }

    @GET
    @Path(value="/data_nodes")
    public List<DataNode> listDataNodes() {
        Map<String, Node> activeDataNodes = this.nodeService.allActive(Node.Type.DATANODE);
        Map preflightDataNodes = this.dataNodeProvisioningService.streamAll().collect(Collectors.toMap(DataNodeProvisioningConfig::nodeId, Function.identity()));
        return activeDataNodes.values().stream().map(n -> {
            DataNodeProvisioningConfig preflight = (DataNodeProvisioningConfig)preflightDataNodes.get(n.getNodeId());
            return new DataNode(n.getNodeId(), n.getType(), n.getTransportAddress(), preflight != null ? preflight.state() : null, preflight != null ? preflight.errorMsg() : null, n.getHostname(), n.getShortNodeId());
        }).collect(Collectors.toList());
    }

    @GET
    @Path(value="/ca")
    public CA get() throws KeyStoreStorageException {
        return this.caService.get();
    }

    @POST
    @Path(value="/ca/create")
    @NoAuditEvent(value="No Audit Event needed")
    public void createCA(@NotNull @Valid CreateCARequest request) throws CACreationException, KeyStoreStorageException, KeyStoreException, NoSuchAlgorithmException {
        this.caService.create(request.organization(), 3650, this.passwordSecret.toCharArray());
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="/ca/upload")
    @NoAuditEvent(value="No Audit Event needed")
    public Response uploadCA(@FormDataParam(value="password") String password, @FormDataParam(value="files") List<FormDataBodyPart> bodyParts) {
        try {
            this.caService.upload(password, bodyParts);
            return Response.ok().build();
        }
        catch (CACreationException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ApiError.create(e.getMessage())).build();
        }
    }

    @DELETE
    @Path(value="/startOver")
    @NoAuditEvent(value="No Audit Event needed")
    public void startOver() {
        this.caService.startOver();
        this.clusterConfigService.remove(RenewalPolicy.class);
        this.dataNodeProvisioningService.deleteAll();
    }

    @DELETE
    @Path(value="/startOver/{nodeID}")
    @NoAuditEvent(value="No Audit Event needed")
    public void startOver(@PathParam(value="nodeID") String nodeID) {
        this.dataNodeProvisioningService.delete(nodeID);
    }

    @POST
    @Path(value="/generate")
    @NoAuditEvent(value="No Audit Event needed")
    public void generate() {
        Map<String, Node> activeDataNodes = this.nodeService.allActive(Node.Type.DATANODE);
        activeDataNodes.values().forEach(node -> this.dataNodeProvisioningService.changeState(node.getNodeId(), DataNodeProvisioningConfig.State.CONFIGURED));
    }

    @POST
    @Path(value="/{nodeID}")
    @Consumes(value={"application/json"})
    @NoAuditEvent(value="No Audit Event needed")
    public void addParameters(@PathParam(value="nodeID") String nodeID, @NotNull CertParameters params) {
        DataNodeProvisioningConfig cfg = this.dataNodeProvisioningService.getPreflightConfigFor(nodeID);
        DataNodeProvisioningConfig.Builder builder = cfg != null ? cfg.toBuilder() : DataNodeProvisioningConfig.builder().nodeId(nodeID);
        builder.altNames(params.altNames()).validFor(params.validFor());
        this.dataNodeProvisioningService.save(builder.build());
    }

    record DataNode(String nodeId, Node.Type type, String transportAddress, DataNodeProvisioningConfig.State status, String errorMsg, String hostname, String shortNodeId) {
    }
}

