/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.graylog2.configuration.IndexSetsDefaultConfiguration;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;

final class AutoValue_IndexSetsDefaultConfiguration
extends IndexSetsDefaultConfiguration {
    @NotBlank
    private final String indexAnalyzer;
    @Min(value=1L)
    private final @Min(value=1L) int shards;
    @Min(value=0L)
    private final @Min(value=0L) int replicas;
    @Min(value=1L)
    private final @Min(value=1L) int indexOptimizationMaxNumSegments;
    private final boolean indexOptimizationDisabled;
    @Min(value=0L)
    private final @Min(value=0L) long fieldTypeRefreshInterval;
    private final TimeUnit fieldTypeRefreshIntervalUnit;
    @NotBlank
    private final String rotationStrategyClass;
    @NotNull
    private final RotationStrategyConfig rotationStrategyConfig;
    @NotBlank
    private final String retentionStrategyClass;
    @NotNull
    private final RetentionStrategyConfig retentionStrategyConfig;

    private AutoValue_IndexSetsDefaultConfiguration(@NotBlank String indexAnalyzer, @Min(value=1L) @Min(value=1L) int shards, @Min(value=0L) @Min(value=0L) int replicas, @Min(value=1L) @Min(value=1L) int indexOptimizationMaxNumSegments, boolean indexOptimizationDisabled, @Min(value=0L) @Min(value=0L) long fieldTypeRefreshInterval, TimeUnit fieldTypeRefreshIntervalUnit, @NotBlank String rotationStrategyClass, @NotNull RotationStrategyConfig rotationStrategyConfig, @NotBlank String retentionStrategyClass, @NotNull RetentionStrategyConfig retentionStrategyConfig) {
        this.indexAnalyzer = indexAnalyzer;
        this.shards = shards;
        this.replicas = replicas;
        this.indexOptimizationMaxNumSegments = indexOptimizationMaxNumSegments;
        this.indexOptimizationDisabled = indexOptimizationDisabled;
        this.fieldTypeRefreshInterval = fieldTypeRefreshInterval;
        this.fieldTypeRefreshIntervalUnit = fieldTypeRefreshIntervalUnit;
        this.rotationStrategyClass = rotationStrategyClass;
        this.rotationStrategyConfig = rotationStrategyConfig;
        this.retentionStrategyClass = retentionStrategyClass;
        this.retentionStrategyConfig = retentionStrategyConfig;
    }

    @Override
    @JsonProperty(value="index_analyzer")
    @NotBlank
    public String indexAnalyzer() {
        return this.indexAnalyzer;
    }

    @Override
    @JsonProperty(value="shards")
    @Min(value=1L)
    public @Min(value=1L) int shards() {
        return this.shards;
    }

    @Override
    @JsonProperty(value="replicas")
    @Min(value=0L)
    public @Min(value=0L) int replicas() {
        return this.replicas;
    }

    @Override
    @JsonProperty(value="index_optimization_max_num_segments")
    @Min(value=1L)
    public @Min(value=1L) int indexOptimizationMaxNumSegments() {
        return this.indexOptimizationMaxNumSegments;
    }

    @Override
    @JsonProperty(value="index_optimization_disabled")
    public boolean indexOptimizationDisabled() {
        return this.indexOptimizationDisabled;
    }

    @Override
    @JsonProperty(value="field_type_refresh_interval")
    @Min(value=0L)
    public @Min(value=0L) long fieldTypeRefreshInterval() {
        return this.fieldTypeRefreshInterval;
    }

    @Override
    @JsonProperty(value="field_type_refresh_interval_unit")
    public TimeUnit fieldTypeRefreshIntervalUnit() {
        return this.fieldTypeRefreshIntervalUnit;
    }

    @Override
    @JsonProperty(value="rotation_strategy_class")
    @NotBlank
    public String rotationStrategyClass() {
        return this.rotationStrategyClass;
    }

    @Override
    @JsonProperty(value="rotation_strategy_config")
    @NotNull
    public RotationStrategyConfig rotationStrategyConfig() {
        return this.rotationStrategyConfig;
    }

    @Override
    @JsonProperty(value="retention_strategy_class")
    @NotBlank
    public String retentionStrategyClass() {
        return this.retentionStrategyClass;
    }

    @Override
    @JsonProperty(value="retention_strategy_config")
    @NotNull
    public RetentionStrategyConfig retentionStrategyConfig() {
        return this.retentionStrategyConfig;
    }

    public String toString() {
        return "IndexSetsDefaultConfiguration{indexAnalyzer=" + this.indexAnalyzer + ", shards=" + this.shards + ", replicas=" + this.replicas + ", indexOptimizationMaxNumSegments=" + this.indexOptimizationMaxNumSegments + ", indexOptimizationDisabled=" + this.indexOptimizationDisabled + ", fieldTypeRefreshInterval=" + this.fieldTypeRefreshInterval + ", fieldTypeRefreshIntervalUnit=" + this.fieldTypeRefreshIntervalUnit + ", rotationStrategyClass=" + this.rotationStrategyClass + ", rotationStrategyConfig=" + this.rotationStrategyConfig + ", retentionStrategyClass=" + this.retentionStrategyClass + ", retentionStrategyConfig=" + this.retentionStrategyConfig + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IndexSetsDefaultConfiguration) {
            IndexSetsDefaultConfiguration that = (IndexSetsDefaultConfiguration)o;
            return this.indexAnalyzer.equals(that.indexAnalyzer()) && this.shards == that.shards() && this.replicas == that.replicas() && this.indexOptimizationMaxNumSegments == that.indexOptimizationMaxNumSegments() && this.indexOptimizationDisabled == that.indexOptimizationDisabled() && this.fieldTypeRefreshInterval == that.fieldTypeRefreshInterval() && this.fieldTypeRefreshIntervalUnit.equals((Object)that.fieldTypeRefreshIntervalUnit()) && this.rotationStrategyClass.equals(that.rotationStrategyClass()) && this.rotationStrategyConfig.equals(that.rotationStrategyConfig()) && this.retentionStrategyClass.equals(that.retentionStrategyClass()) && this.retentionStrategyConfig.equals(that.retentionStrategyConfig());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.indexAnalyzer.hashCode();
        h$ *= 1000003;
        h$ ^= this.shards;
        h$ *= 1000003;
        h$ ^= this.replicas;
        h$ *= 1000003;
        h$ ^= this.indexOptimizationMaxNumSegments;
        h$ *= 1000003;
        h$ ^= this.indexOptimizationDisabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= (int)(this.fieldTypeRefreshInterval >>> 32 ^ this.fieldTypeRefreshInterval);
        h$ *= 1000003;
        h$ ^= this.fieldTypeRefreshIntervalUnit.hashCode();
        h$ *= 1000003;
        h$ ^= this.rotationStrategyClass.hashCode();
        h$ *= 1000003;
        h$ ^= this.rotationStrategyConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.retentionStrategyClass.hashCode();
        h$ *= 1000003;
        return h$ ^= this.retentionStrategyConfig.hashCode();
    }

    @Override
    public IndexSetsDefaultConfiguration.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends IndexSetsDefaultConfiguration.Builder {
        @NotBlank
        private String indexAnalyzer;
        @Min(value=1L)
        private @Min(value=1L) int shards;
        @Min(value=0L)
        private @Min(value=0L) int replicas;
        @Min(value=1L)
        private @Min(value=1L) int indexOptimizationMaxNumSegments;
        private boolean indexOptimizationDisabled;
        @Min(value=0L)
        private @Min(value=0L) long fieldTypeRefreshInterval;
        private TimeUnit fieldTypeRefreshIntervalUnit;
        @NotBlank
        private String rotationStrategyClass;
        @NotNull
        private RotationStrategyConfig rotationStrategyConfig;
        @NotBlank
        private String retentionStrategyClass;
        @NotNull
        private RetentionStrategyConfig retentionStrategyConfig;
        private byte set$0;

        Builder() {
        }

        private Builder(IndexSetsDefaultConfiguration source) {
            this.indexAnalyzer = source.indexAnalyzer();
            this.shards = source.shards();
            this.replicas = source.replicas();
            this.indexOptimizationMaxNumSegments = source.indexOptimizationMaxNumSegments();
            this.indexOptimizationDisabled = source.indexOptimizationDisabled();
            this.fieldTypeRefreshInterval = source.fieldTypeRefreshInterval();
            this.fieldTypeRefreshIntervalUnit = source.fieldTypeRefreshIntervalUnit();
            this.rotationStrategyClass = source.rotationStrategyClass();
            this.rotationStrategyConfig = source.rotationStrategyConfig();
            this.retentionStrategyClass = source.retentionStrategyClass();
            this.retentionStrategyConfig = source.retentionStrategyConfig();
            this.set$0 = (byte)31;
        }

        @Override
        public IndexSetsDefaultConfiguration.Builder indexAnalyzer(String indexAnalyzer) {
            if (indexAnalyzer == null) {
                throw new NullPointerException("Null indexAnalyzer");
            }
            this.indexAnalyzer = indexAnalyzer;
            return this;
        }

        @Override
        public IndexSetsDefaultConfiguration.Builder shards(int shards) {
            this.shards = shards;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public IndexSetsDefaultConfiguration.Builder replicas(int replicas) {
            this.replicas = replicas;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        public IndexSetsDefaultConfiguration.Builder indexOptimizationMaxNumSegments(int indexOptimizationMaxNumSegments) {
            this.indexOptimizationMaxNumSegments = indexOptimizationMaxNumSegments;
            this.set$0 = (byte)(this.set$0 | 4);
            return this;
        }

        @Override
        public IndexSetsDefaultConfiguration.Builder indexOptimizationDisabled(boolean indexOptimizationDisabled) {
            this.indexOptimizationDisabled = indexOptimizationDisabled;
            this.set$0 = (byte)(this.set$0 | 8);
            return this;
        }

        @Override
        public IndexSetsDefaultConfiguration.Builder fieldTypeRefreshInterval(long fieldTypeRefreshInterval) {
            this.fieldTypeRefreshInterval = fieldTypeRefreshInterval;
            this.set$0 = (byte)(this.set$0 | 0x10);
            return this;
        }

        @Override
        public IndexSetsDefaultConfiguration.Builder fieldTypeRefreshIntervalUnit(TimeUnit fieldTypeRefreshIntervalUnit) {
            if (fieldTypeRefreshIntervalUnit == null) {
                throw new NullPointerException("Null fieldTypeRefreshIntervalUnit");
            }
            this.fieldTypeRefreshIntervalUnit = fieldTypeRefreshIntervalUnit;
            return this;
        }

        @Override
        public IndexSetsDefaultConfiguration.Builder rotationStrategyClass(String rotationStrategyClass) {
            if (rotationStrategyClass == null) {
                throw new NullPointerException("Null rotationStrategyClass");
            }
            this.rotationStrategyClass = rotationStrategyClass;
            return this;
        }

        @Override
        public IndexSetsDefaultConfiguration.Builder rotationStrategyConfig(RotationStrategyConfig rotationStrategyConfig) {
            if (rotationStrategyConfig == null) {
                throw new NullPointerException("Null rotationStrategyConfig");
            }
            this.rotationStrategyConfig = rotationStrategyConfig;
            return this;
        }

        @Override
        public IndexSetsDefaultConfiguration.Builder retentionStrategyClass(String retentionStrategyClass) {
            if (retentionStrategyClass == null) {
                throw new NullPointerException("Null retentionStrategyClass");
            }
            this.retentionStrategyClass = retentionStrategyClass;
            return this;
        }

        @Override
        public IndexSetsDefaultConfiguration.Builder retentionStrategyConfig(RetentionStrategyConfig retentionStrategyConfig) {
            if (retentionStrategyConfig == null) {
                throw new NullPointerException("Null retentionStrategyConfig");
            }
            this.retentionStrategyConfig = retentionStrategyConfig;
            return this;
        }

        @Override
        public IndexSetsDefaultConfiguration build() {
            if (this.set$0 != 31 || this.indexAnalyzer == null || this.fieldTypeRefreshIntervalUnit == null || this.rotationStrategyClass == null || this.rotationStrategyConfig == null || this.retentionStrategyClass == null || this.retentionStrategyConfig == null) {
                StringBuilder missing = new StringBuilder();
                if (this.indexAnalyzer == null) {
                    missing.append(" indexAnalyzer");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" shards");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" replicas");
                }
                if ((this.set$0 & 4) == 0) {
                    missing.append(" indexOptimizationMaxNumSegments");
                }
                if ((this.set$0 & 8) == 0) {
                    missing.append(" indexOptimizationDisabled");
                }
                if ((this.set$0 & 0x10) == 0) {
                    missing.append(" fieldTypeRefreshInterval");
                }
                if (this.fieldTypeRefreshIntervalUnit == null) {
                    missing.append(" fieldTypeRefreshIntervalUnit");
                }
                if (this.rotationStrategyClass == null) {
                    missing.append(" rotationStrategyClass");
                }
                if (this.rotationStrategyConfig == null) {
                    missing.append(" rotationStrategyConfig");
                }
                if (this.retentionStrategyClass == null) {
                    missing.append(" retentionStrategyClass");
                }
                if (this.retentionStrategyConfig == null) {
                    missing.append(" retentionStrategyConfig");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_IndexSetsDefaultConfiguration(this.indexAnalyzer, this.shards, this.replicas, this.indexOptimizationMaxNumSegments, this.indexOptimizationDisabled, this.fieldTypeRefreshInterval, this.fieldTypeRefreshIntervalUnit, this.rotationStrategyClass, this.rotationStrategyConfig, this.retentionStrategyClass, this.retentionStrategyConfig);
        }
    }
}

