/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.client.MongoCollection;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.bson.UuidRepresentation;
import org.graylog.shaded.mongojack4.org.mongojack.JacksonMongoCollection;
import org.graylog.shaded.mongojack4.org.mongojack.internal.MongoJackModule;
import org.graylog2.bindings.providers.CommonMongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;

@Singleton
public class MongoCollections {
    private final ObjectMapper objectMapper;
    private final MongoConnection mongoConnection;

    @Inject
    public MongoCollections(CommonMongoJackObjectMapperProvider objectMapperProvider, MongoConnection mongoConnection) {
        this.objectMapper = objectMapperProvider.get();
        this.mongoConnection = mongoConnection;
        MongoJackModule.configure((ObjectMapper)this.objectMapper);
    }

    public <T> MongoCollection<T> get(String collectionName, Class<T> valueType) {
        return JacksonMongoCollection.builder().withObjectMapper(this.objectMapper).build(this.mongoConnection.getMongoDatabase(), collectionName, valueType, UuidRepresentation.UNSPECIFIED);
    }
}

