/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.fieldtypes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Singleton;
import org.graylog2.indexer.fieldtypes.FieldTypeDTO;
import org.graylog2.indexer.fieldtypes.FieldTypes;

@Singleton
public class FieldTypeMapper {
    private static final String PROP_ENUMERABLE = "enumerable";
    public static final String PROP_FULL_TEXT_SEARCH = "full-text-search";
    public static final String PROP_NUMERIC = "numeric";
    public static final FieldTypes.Type STRING_TYPE = FieldTypes.Type.createType("string", (Set<String>)ImmutableSet.of((Object)"enumerable"));
    public static final FieldTypes.Type STRING_FTS_TYPE = FieldTypes.Type.createType("string", (Set<String>)ImmutableSet.of((Object)"full-text-search"));
    public static final FieldTypes.Type LONG_TYPE = FieldTypes.Type.createType("long", (Set<String>)ImmutableSet.of((Object)"numeric", (Object)"enumerable"));
    public static final FieldTypes.Type INT_TYPE = FieldTypes.Type.createType("int", (Set<String>)ImmutableSet.of((Object)"numeric", (Object)"enumerable"));
    public static final FieldTypes.Type SHORT_TYPE = FieldTypes.Type.createType("short", (Set<String>)ImmutableSet.of((Object)"numeric", (Object)"enumerable"));
    public static final FieldTypes.Type BYTE_TYPE = FieldTypes.Type.createType("byte", (Set<String>)ImmutableSet.of((Object)"numeric", (Object)"enumerable"));
    public static final FieldTypes.Type DOUBLE_TYPE = FieldTypes.Type.createType("double", (Set<String>)ImmutableSet.of((Object)"numeric", (Object)"enumerable"));
    public static final FieldTypes.Type FLOAT_TYPE = FieldTypes.Type.createType("float", (Set<String>)ImmutableSet.of((Object)"numeric", (Object)"enumerable"));
    public static final FieldTypes.Type DATE_TYPE = FieldTypes.Type.createType("date", (Set<String>)ImmutableSet.of((Object)"enumerable"));
    public static final FieldTypes.Type BOOLEAN_TYPE = FieldTypes.Type.createType("boolean", (Set<String>)ImmutableSet.of((Object)"enumerable"));
    public static final FieldTypes.Type BINARY_TYPE = FieldTypes.Type.createType("binary", (Set<String>)ImmutableSet.of());
    public static final FieldTypes.Type GEO_POINT_TYPE = FieldTypes.Type.createType("geo-point", (Set<String>)ImmutableSet.of());
    public static final FieldTypes.Type IP_TYPE = FieldTypes.Type.createType("ip", (Set<String>)ImmutableSet.of((Object)"enumerable"));
    public static final FieldTypes.Type STREAMS_TYPE = FieldTypes.Type.createType("streams", (Set<String>)ImmutableSet.of((Object)"enumerable"));
    public static final FieldTypes.Type INPUT_TYPE = FieldTypes.Type.createType("input", (Set<String>)ImmutableSet.of((Object)"enumerable"));
    public static final FieldTypes.Type NODE_TYPE = FieldTypes.Type.createType("node", (Set<String>)ImmutableSet.of((Object)"enumerable"));
    public static final Map<String, FieldTypes.Type> TYPE_MAP = ImmutableMap.builder().put((Object)"keyword", (Object)STRING_TYPE).put((Object)"text", (Object)STRING_FTS_TYPE).put((Object)"long", (Object)LONG_TYPE).put((Object)"integer", (Object)INT_TYPE).put((Object)"short", (Object)SHORT_TYPE).put((Object)"byte", (Object)BYTE_TYPE).put((Object)"double", (Object)DOUBLE_TYPE).put((Object)"float", (Object)FLOAT_TYPE).put((Object)"half_float", (Object)FLOAT_TYPE).put((Object)"scaled_float", (Object)FLOAT_TYPE).put((Object)"date", (Object)DATE_TYPE).put((Object)"boolean", (Object)BOOLEAN_TYPE).put((Object)"binary", (Object)BINARY_TYPE).put((Object)"geo_point", (Object)GEO_POINT_TYPE).put((Object)"ip", (Object)IP_TYPE).build();
    private static final Map<String, FieldTypes.Type> FIELD_MAP = Map.of("streams", STREAMS_TYPE, "gl2_source_input", INPUT_TYPE, "gl2_source_node", NODE_TYPE);

    public Optional<FieldTypes.Type> mapType(FieldTypeDTO type) {
        return Optional.ofNullable(FIELD_MAP.get(type.fieldName())).or(() -> Optional.ofNullable(TYPE_MAP.get(type.physicalType()))).map(mappedType -> type.properties().contains((Object)FieldTypeDTO.Properties.FIELDDATA) ? mappedType.toBuilder().properties((Set<String>)new ImmutableSet.Builder().addAll(mappedType.properties()).add((Object)PROP_ENUMERABLE).build()).build() : mappedType);
    }
}

