/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.fieldtypes.mapping;

import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.graylog2.indexer.MongoIndexSet;
import org.graylog2.indexer.indexset.CustomFieldMapping;
import org.graylog2.indexer.indexset.CustomFieldMappings;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indexset.IndexSetService;
import org.graylog2.indexer.indexset.MongoIndexSetService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldTypeMappingsService {
    private static final Logger LOG = LoggerFactory.getLogger(FieldTypeMappingsService.class);
    private final IndexSetService indexSetService;
    private final MongoIndexSet.Factory mongoIndexSetFactory;
    private final MongoIndexSetService mongoIndexSetService;

    @Inject
    public FieldTypeMappingsService(IndexSetService indexSetService, MongoIndexSet.Factory mongoIndexSetFactory, MongoIndexSetService mongoIndexSetService) {
        this.indexSetService = indexSetService;
        this.mongoIndexSetFactory = mongoIndexSetFactory;
        this.mongoIndexSetService = mongoIndexSetService;
    }

    public void changeFieldType(CustomFieldMapping customMapping, Set<String> indexSetsIds, boolean rotateImmediately) {
        for (String indexSetId : indexSetsIds) {
            try {
                this.indexSetService.get(indexSetId).ifPresent(indexSetConfig -> {
                    Optional<IndexSetConfig> updatedIndexSetConfig = this.storeMapping(customMapping, (IndexSetConfig)indexSetConfig);
                    if (rotateImmediately) {
                        updatedIndexSetConfig.ifPresent(this::cycleIndexSet);
                    }
                });
            }
            catch (Exception ex) {
                LOG.error("Failed to update field type in index set : " + indexSetId, (Throwable)ex);
            }
        }
    }

    private Optional<IndexSetConfig> storeMapping(CustomFieldMapping customMapping, IndexSetConfig indexSetConfig) {
        CustomFieldMappings previousCustomFieldMappings = indexSetConfig.customFieldMappings();
        if (previousCustomFieldMappings.contains(customMapping)) {
            return Optional.empty();
        }
        return Optional.of(this.mongoIndexSetService.save(indexSetConfig.toBuilder().customFieldMappings(previousCustomFieldMappings.mergeWith(customMapping)).build()));
    }

    private void cycleIndexSet(IndexSetConfig indexSetConfig) {
        MongoIndexSet mongoIndexSet = this.mongoIndexSetFactory.create(indexSetConfig);
        mongoIndexSet.cycle();
    }
}

