/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.searches;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class SearchFailure {
    private final List<String> errors;

    public SearchFailure(JsonNode shards) {
        this.errors = StreamSupport.stream(shards.path("failures").spliterator(), false).map(failure -> {
            String error = failure.path("reason").path("reason").asText();
            String caused_by = failure.path("reason").path("caused_by").toString();
            if (!caused_by.isEmpty()) {
                return error + " caused_by: " + caused_by;
            }
            return error;
        }).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public List<String> getNonNumericFieldErrors() {
        return this.errors.stream().filter(error -> error.startsWith("Expected numeric type on field") || error.contains("\"type\":\"number_format_exception")).collect(Collectors.toList());
    }
}

