/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.caches;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import com.google.auto.value.AutoValue;
import com.google.inject.assistedinject.Assisted;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.Min;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.graylog2.lookup.caches.$AutoValue_CaffeineLookupCache_Config;
import org.graylog2.plugin.lookup.LookupCache;
import org.graylog2.plugin.lookup.LookupCacheConfiguration;
import org.graylog2.plugin.lookup.LookupCacheKey;
import org.graylog2.plugin.lookup.LookupResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineLookupCache
extends LookupCache {
    private static final Logger LOG = LoggerFactory.getLogger(CaffeineLookupCache.class);
    public static final String NAME = "guava_cache";
    private final Cache<LookupCacheKey, LookupResult> cache;
    private final Config config;

    @Inject
    public CaffeineLookupCache(@Assisted(value="id") String id, @Assisted(value="name") String name, @Assisted LookupCacheConfiguration c, @Named(value="processbuffer_processors") int processorCount, MetricRegistry metricRegistry) {
        super(id, name, c, metricRegistry);
        this.config = (Config)c;
        Caffeine builder = Caffeine.newBuilder();
        builder.recordStats(() -> new MetricStatsCounter(this));
        builder.maximumSize((long)this.config.maxSize());
        builder.expireAfter(this.buildExpiry(this.config));
        this.cache = builder.build();
    }

    private Expiry<LookupCacheKey, LookupResult> buildExpiry(final Config config) {
        return new Expiry<LookupCacheKey, LookupResult>(){

            public long expireAfterCreate(@NonNull LookupCacheKey lookupCacheKey, @NonNull LookupResult lookupResult, long currentTime) {
                if (lookupResult.hasTTL()) {
                    return TimeUnit.MILLISECONDS.toNanos(lookupResult.cacheTTL());
                }
                if (config.expireAfterWrite() > 0L && config.expireAfterWriteUnit() != null) {
                    return config.expireAfterWriteUnit().toNanos(config.expireAfterWrite());
                }
                return Long.MAX_VALUE;
            }

            public long expireAfterUpdate(@NonNull LookupCacheKey lookupCacheKey, @NonNull LookupResult lookupResult, long currentTime, long currentDuration) {
                return currentDuration;
            }

            public long expireAfterRead(@NonNull LookupCacheKey lookupCacheKey, @NonNull LookupResult lookupResult, long currentTime, long currentDuration) {
                if (config.expireAfterAccess() > 0L && config.expireAfterAccessUnit() != null) {
                    return config.expireAfterAccessUnit().toNanos(config.expireAfterAccess());
                }
                return currentDuration;
            }
        };
    }

    @Override
    public long entryCount() {
        if (this.cache != null) {
            return this.cache.estimatedSize();
        }
        return 0L;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    public LookupResult get(LookupCacheKey key, Callable<LookupResult> loader) {
        Function<LookupCacheKey, LookupResult> mapFunction = unused -> {
            try {
                LookupResult result = (LookupResult)loader.call();
                if (this.ignoreResult(result, this.config.ignoreNull())) {
                    LOG.debug("Ignoring failed lookup for key {}", (Object)key);
                    return LookupResult.builder().cacheTTL(0L).build();
                }
                return result;
            }
            catch (Exception e) {
                LOG.warn("Loading value from data adapter failed for key {}, returning empty result", (Object)key, (Object)e);
                return LookupResult.withError(String.format(Locale.ENGLISH, "Loading value from data adapter failed for key <%s>: %s", key.toString(), e.getMessage()));
            }
        };
        try (Timer.Context ignored = this.lookupTimer();){
            LookupResult lookupResult = (LookupResult)this.cache.get((Object)key, mapFunction);
            return lookupResult;
        }
    }

    private boolean ignoreResult(LookupResult result, Boolean ignoreNull) {
        if (ignoreNull == null || !ignoreNull.booleanValue()) {
            return false;
        }
        return result == null || result.singleValue() == null && result.multiValue() == null && result.stringListValue() == null;
    }

    @Override
    public LookupResult getIfPresent(LookupCacheKey key) {
        LookupResult cacheEntry = (LookupResult)this.cache.getIfPresent((Object)key);
        if (cacheEntry == null) {
            return LookupResult.empty();
        }
        return cacheEntry;
    }

    @Override
    public void purge() {
        this.cache.invalidateAll();
    }

    @Override
    public void purge(LookupCacheKey purgeKey) {
        if (purgeKey.isPrefixOnly()) {
            this.cache.invalidateAll((Iterable)this.cache.asMap().keySet().stream().filter(lookupCacheKey -> purgeKey.prefix().equals(lookupCacheKey.prefix())).collect(Collectors.toSet()));
        } else {
            this.cache.invalidate((Object)purgeKey);
        }
    }

    @JsonAutoDetect
    @JsonDeserialize(builder=$AutoValue_CaffeineLookupCache_Config.Builder.class)
    @JsonTypeName(value="guava_cache")
    @AutoValue
    public static abstract class Config
    implements LookupCacheConfiguration {
        @Min(value=0L)
        @JsonProperty(value="max_size")
        public abstract @Min(value=0L) int maxSize();

        @Min(value=0L)
        @JsonProperty(value="expire_after_access")
        public abstract @Min(value=0L) long expireAfterAccess();

        @Nullable
        @JsonProperty(value="expire_after_access_unit")
        public abstract TimeUnit expireAfterAccessUnit();

        @Min(value=0L)
        @JsonProperty(value="expire_after_write")
        public abstract @Min(value=0L) long expireAfterWrite();

        @Nullable
        @JsonProperty(value="expire_after_write_unit")
        public abstract TimeUnit expireAfterWriteUnit();

        @Nullable
        @JsonProperty(value="ignore_null")
        public abstract Boolean ignoreNull();

        public static Builder builder() {
            return new $AutoValue_CaffeineLookupCache_Config.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonProperty(value="type")
            public abstract Builder type(String var1);

            @JsonProperty(value="max_size")
            public abstract Builder maxSize(int var1);

            @JsonProperty(value="expire_after_access")
            public abstract Builder expireAfterAccess(long var1);

            @JsonProperty(value="expire_after_access_unit")
            public abstract Builder expireAfterAccessUnit(@Nullable TimeUnit var1);

            @JsonProperty(value="expire_after_write")
            public abstract Builder expireAfterWrite(long var1);

            @JsonProperty(value="expire_after_write_unit")
            public abstract Builder expireAfterWriteUnit(@Nullable TimeUnit var1);

            @JsonProperty(value="ignore_null")
            public abstract Builder ignoreNull(@Nullable Boolean var1);

            public abstract Config build();
        }
    }

    private static class MetricStatsCounter
    implements StatsCounter {
        private final LookupCache cache;

        MetricStatsCounter(LookupCache cache) {
            this.cache = cache;
        }

        public void recordHits(int count) {
            this.cache.incrHitCount(count);
            this.cache.incrTotalCount(count);
        }

        public void recordMisses(int count) {
            this.cache.incrMissCount(count);
            this.cache.incrTotalCount(count);
        }

        public void recordLoadSuccess(long loadTime) {
        }

        public void recordLoadFailure(long loadTime) {
        }

        public void recordEviction() {
        }

        public @NonNull CacheStats snapshot() {
            throw new UnsupportedOperationException("snapshots not implemented");
        }
    }

    public static class Descriptor
    extends LookupCache.Descriptor<Config> {
        public Descriptor() {
            super(CaffeineLookupCache.NAME, Config.class);
        }

        @Override
        public Config defaultConfiguration() {
            return Config.builder().type(CaffeineLookupCache.NAME).maxSize(1000).expireAfterAccess(60L).expireAfterAccessUnit(TimeUnit.SECONDS).expireAfterWrite(0L).ignoreNull(false).build();
        }
    }

    public static interface Factory
    extends LookupCache.Factory {
        public CaffeineLookupCache create(@Assisted(value="id") String var1, @Assisted(value="name") String var2, LookupCacheConfiguration var3);

        @Override
        public Descriptor getDescriptor();
    }
}

