/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import java.time.ZonedDateTime;
import javax.inject.Inject;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.searches.SearchesClusterConfig;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20151210140600_AddSearchesClusterConfigMigration
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20151210140600_AddSearchesClusterConfigMigration.class);
    private final ClusterConfigService clusterConfigService;
    private final ElasticsearchConfiguration elasticsearchConfiguration;

    @Inject
    public V20151210140600_AddSearchesClusterConfigMigration(ClusterConfigService clusterConfigService, ElasticsearchConfiguration elasticsearchConfiguration) {
        this.clusterConfigService = clusterConfigService;
        this.elasticsearchConfiguration = elasticsearchConfiguration;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2015-12-10T14:06:00Z");
    }

    @Override
    public void upgrade() {
        SearchesClusterConfig searchesClusterConfig = this.clusterConfigService.get(SearchesClusterConfig.class);
        if (searchesClusterConfig == null) {
            SearchesClusterConfig config = SearchesClusterConfig.createDefault();
            LOG.info("Creating searches cluster config: {}", (Object)config);
            this.clusterConfigService.write(config);
        }
    }
}

