/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.web;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.graylog2.web.DevelopmentIndexHtmlGenerator;
import org.graylog2.web.IndexHtmlGenerator;
import org.graylog2.web.ProductionIndexHtmlGenerator;

@Singleton
public class IndexHtmlGeneratorProvider
implements Provider<IndexHtmlGenerator> {
    private final Supplier<IndexHtmlGenerator> indexHtmlGeneratorSupplier;

    @Inject
    public IndexHtmlGeneratorProvider(Provider<DevelopmentIndexHtmlGenerator> developmentIndexHtmlGeneratorProvider, Provider<ProductionIndexHtmlGenerator> productionIndexHtmlGeneratorProvider, @Named(value="isDevelopmentServer") Boolean isDevelopmentServer) {
        Object indexHtmlGeneratorProvider = isDevelopmentServer != false ? developmentIndexHtmlGeneratorProvider : productionIndexHtmlGeneratorProvider;
        this.indexHtmlGeneratorSupplier = Suppliers.memoize(() -> indexHtmlGeneratorProvider.get());
    }

    public IndexHtmlGenerator get() {
        return this.indexHtmlGeneratorSupplier.get();
    }
}

