/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.legacy;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.bson.Document;
import org.graylog.events.conditions.Expr;
import org.graylog.events.conditions.Expression;
import org.graylog.events.legacy.AutoValue_LegacyAlertConditionMigrator_MigrationResult;
import org.graylog.events.legacy.LegacyAlarmCallbackEventNotificationConfig;
import org.graylog.events.notifications.DBNotificationService;
import org.graylog.events.notifications.EventNotificationHandler;
import org.graylog.events.notifications.EventNotificationSettings;
import org.graylog.events.notifications.NotificationDto;
import org.graylog.events.notifications.NotificationResourceHandler;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog.events.processor.EventDefinitionHandler;
import org.graylog.events.processor.EventProcessorConfig;
import org.graylog.events.processor.aggregation.AggregationConditions;
import org.graylog.events.processor.aggregation.AggregationEventProcessorConfig;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Average;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Count;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Max;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Min;
import org.graylog.plugins.views.search.searchtypes.pivot.series.StdDev;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Sum;
import org.graylog2.database.MongoConnection;
import org.graylog2.shared.users.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyAlertConditionMigrator {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyAlertConditionMigrator.class);
    private final MongoCollection<Document> streamsCollection;
    private final MongoCollection<Document> alarmCallbacksCollection;
    private final EventDefinitionHandler eventDefinitionHandler;
    private final NotificationResourceHandler notificationResourceHandler;
    private final DBNotificationService dbNotificationService;
    private final UserService userService;
    private final long executeEveryMs;

    @Inject
    public LegacyAlertConditionMigrator(MongoConnection mongoConnection, EventDefinitionHandler eventDefinitionHandler, NotificationResourceHandler notificationResourceHandler, DBNotificationService dbNotificationService, UserService userService, @Named(value="alert_check_interval") int alertCheckInterval) {
        this.streamsCollection = mongoConnection.getMongoDatabase().getCollection("streams");
        this.alarmCallbacksCollection = mongoConnection.getMongoDatabase().getCollection("alarmcallbackconfigurations");
        this.eventDefinitionHandler = eventDefinitionHandler;
        this.notificationResourceHandler = notificationResourceHandler;
        this.dbNotificationService = dbNotificationService;
        this.userService = userService;
        this.executeEveryMs = (long)alertCheckInterval * 1000L;
    }

    public MigrationResult run(Set<String> completedAlertConditions, Set<String> completedAlarmCallbacks) {
        MigrationResult.Builder result = MigrationResult.builder();
        this.streamsCollection.find().forEach(stream -> {
            String streamId = stream.getObjectId((Object)"_id").toHexString();
            String streamTitle = stream.getString((Object)"title");
            FindIterable iterable = this.alarmCallbacksCollection.find(Filters.eq((String)"stream_id", (Object)streamId));
            Set notifications = Streams.stream((Iterable)iterable).map(alarmCallback -> {
                String callbackId = alarmCallback.getObjectId((Object)"_id").toHexString();
                if (completedAlarmCallbacks.contains(callbackId)) {
                    result.addCompletedAlarmCallback(callbackId);
                    return this.dbNotificationService.get(callbackId).orElse(null);
                }
                try {
                    NotificationDto notificationDto = this.migrateAlarmCallback((Document)alarmCallback);
                    result.addCompletedAlarmCallback(callbackId);
                    return notificationDto;
                }
                catch (Exception e) {
                    LOG.error("Couldn't migrate legacy alarm callback on stream <{}/{}>: {}", new Object[]{streamTitle, streamId, alarmCallback, e});
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            if (!stream.containsKey((Object)"alert_conditions")) {
                return;
            }
            List list = (List)stream.get((Object)"alert_conditions");
            list.forEach(alertCondition -> {
                String conditionId = alertCondition.getString((Object)"id");
                String conditionType = alertCondition.getString((Object)"type");
                if (completedAlertConditions.contains(conditionId)) {
                    result.addCompletedAlertCondition(conditionId);
                    return;
                }
                try {
                    switch (conditionType) {
                        case "message_count": {
                            this.migrateMessageCount(new Helper((Document)stream, (Document)alertCondition, notifications));
                            result.addCompletedAlertCondition(conditionId);
                            break;
                        }
                        case "field_value": {
                            this.migrateFieldValue(new Helper((Document)stream, (Document)alertCondition, notifications));
                            result.addCompletedAlertCondition(conditionId);
                            break;
                        }
                        case "field_content_value": {
                            this.migrateFieldContentValue(new Helper((Document)stream, (Document)alertCondition, notifications));
                            result.addCompletedAlertCondition(conditionId);
                            break;
                        }
                        default: {
                            LOG.warn("Couldn't migrate unknown legacy alert condition type: {}", (Object)conditionType);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error("Couldn't migrate legacy alert condition on stream <{}/{}>: {}", new Object[]{streamTitle, streamId, alertCondition, e});
                }
            });
        });
        return result.build();
    }

    private NotificationDto migrateAlarmCallback(Document alarmCallback) {
        String title = alarmCallback.getString((Object)"title");
        String type = alarmCallback.getString((Object)"type");
        Document configDoc = (Document)alarmCallback.get((Object)"configuration");
        Map<String, Object> configuration = configDoc.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        LegacyAlarmCallbackEventNotificationConfig config = LegacyAlarmCallbackEventNotificationConfig.builder().callbackType(type).configuration(configuration).build();
        NotificationDto dto = NotificationDto.builder().title((String)MoreObjects.firstNonNull((Object)title, (Object)"Untitled")).description("Migrated legacy alarm callback").config(config).build();
        LOG.info("Migrate legacy alarm callback <{}>", (Object)dto.title());
        return this.notificationResourceHandler.create(dto, this.userService.getRootUser());
    }

    private void migrateMessageCount(Helper helper) {
        String seriesId = helper.newSeriesId();
        Count messageCountSeries = Count.builder().id(seriesId).build();
        Expression<Boolean> expression = helper.createExpression(seriesId, "MORE");
        EventProcessorConfig config = helper.createAggregationProcessorConfig(messageCountSeries, expression, this.executeEveryMs);
        EventDefinitionDto definitionDto = helper.createEventDefinition(config);
        LOG.info("Migrate legacy message count alert condition <{}>", (Object)definitionDto.title());
        this.eventDefinitionHandler.create(definitionDto, this.userService.getRootUser());
    }

    private void migrateFieldValue(Helper helper) {
        String type = helper.parameters().getString((Object)"type");
        String field = helper.parameters().getString((Object)"field");
        String seriesId = helper.newSeriesId();
        SeriesSpec aggregationSeries = switch (type.toUpperCase(Locale.US)) {
            case "MEAN" -> Average.builder().id(seriesId).field(field).build();
            case "MIN" -> Min.builder().id(seriesId).field(field).build();
            case "MAX" -> Max.builder().id(seriesId).field(field).build();
            case "SUM" -> Sum.builder().id(seriesId).field(field).build();
            case "STDDEV" -> StdDev.builder().id(seriesId).field(field).build();
            default -> throw new IllegalStateException("Couldn't migrate field value alert condition with unknown type: " + type);
        };
        Expression<Boolean> expression = helper.createExpression(seriesId, "HIGHER");
        EventProcessorConfig config = helper.createAggregationProcessorConfig(aggregationSeries, expression, this.executeEveryMs);
        EventDefinitionDto definitionDto = helper.createEventDefinition(config);
        LOG.info("Migrate legacy field value alert condition <{}>", (Object)definitionDto.title());
        this.eventDefinitionHandler.create(definitionDto, this.userService.getRootUser());
    }

    private void migrateFieldContentValue(Helper helper) {
        String field = helper.parameters().getString((Object)"field");
        String value = helper.parameters().getString((Object)"value");
        String query = field + ":\"" + value + "\"";
        if (!Strings.isNullOrEmpty((String)helper.query) && !"*".equals(helper.query.trim())) {
            query = query + " AND " + helper.query;
        }
        String seriesId = helper.newSeriesId();
        Count messageCountSeries = Count.builder().id(seriesId).build();
        Expr.NumberReference left = Expr.NumberReference.create(seriesId);
        Expr.NumberValue right = Expr.NumberValue.create(0.0);
        Expr.Greater expression = Expr.Greater.create(left, right);
        AggregationEventProcessorConfig config = AggregationEventProcessorConfig.builder().streams((Set<String>)ImmutableSet.of((Object)helper.streamId)).query(query).series((List<SeriesSpec>)ImmutableList.of((Object)messageCountSeries)).groupBy((List<String>)ImmutableList.of()).conditions(AggregationConditions.builder().expression(expression).build()).searchWithinMs(this.executeEveryMs).executeEveryMs(this.executeEveryMs).build();
        EventDefinitionDto definitionDto = helper.createEventDefinition(config);
        LOG.info("Migrate legacy field content value alert condition <{}>", (Object)definitionDto.title());
        this.eventDefinitionHandler.create(definitionDto, this.userService.getRootUser());
    }

    @AutoValue
    public static abstract class MigrationResult {
        public abstract ImmutableSet<String> completedAlertConditions();

        public abstract ImmutableSet<String> completedAlarmCallbacks();

        public static Builder builder() {
            return new AutoValue_LegacyAlertConditionMigrator_MigrationResult.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            abstract ImmutableSet.Builder<String> completedAlertConditionsBuilder();

            abstract ImmutableSet.Builder<String> completedAlarmCallbacksBuilder();

            public Builder addCompletedAlertCondition(String id) {
                this.completedAlertConditionsBuilder().add((Object)id);
                return this;
            }

            public Builder addCompletedAlarmCallback(String id) {
                this.completedAlarmCallbacksBuilder().add((Object)id);
                return this;
            }

            public abstract MigrationResult build();
        }
    }

    private static class Helper {
        private final String streamId;
        private final String title;
        private final Document parameters;
        private final Set<NotificationDto> notifications;
        private final long gracePeriod;
        private final long backlogSize;
        private final String query;
        private final long time;
        private final long threshold;
        private final String thresholdType;

        Helper(Document stream, Document alertCondition, Set<NotificationDto> notifications) {
            this.streamId = stream.getObjectId((Object)"_id").toHexString();
            this.title = alertCondition.getString((Object)"title");
            this.parameters = (Document)alertCondition.get((Object)"parameters");
            this.notifications = notifications;
            this.gracePeriod = ((Number)MoreObjects.firstNonNull((Object)((Number)this.parameters.get((Object)"grace")), (Object)0)).longValue();
            this.backlogSize = ((Number)MoreObjects.firstNonNull((Object)((Number)this.parameters.get((Object)"backlog")), (Object)0)).longValue();
            this.query = (String)this.parameters.get((Object)"query", (Object)"");
            this.time = ((Number)MoreObjects.firstNonNull((Object)((Number)this.parameters.get((Object)"time")), (Object)0)).longValue();
            this.threshold = ((Number)MoreObjects.firstNonNull((Object)((Number)this.parameters.get((Object)"threshold")), (Object)0)).longValue();
            this.thresholdType = (String)this.parameters.get((Object)"threshold_type", (Object)"MORE");
        }

        Document parameters() {
            return this.parameters;
        }

        EventProcessorConfig createAggregationProcessorConfig(SeriesSpec aggregationSeries, Expression<Boolean> expression, long executeEveryMs) {
            return AggregationEventProcessorConfig.builder().streams((Set<String>)ImmutableSet.of((Object)this.streamId)).query(this.query).series((List<SeriesSpec>)ImmutableList.of((Object)aggregationSeries)).groupBy((List<String>)ImmutableList.of()).conditions(AggregationConditions.builder().expression(expression).build()).searchWithinMs(this.time * 60L * 1000L).executeEveryMs(executeEveryMs).build();
        }

        Expression<Boolean> createExpression(String seriesId, String greaterValue) {
            Expr.NumberReference left = Expr.NumberReference.create(seriesId);
            Expr.NumberValue right = Expr.NumberValue.create(this.threshold);
            return greaterValue.equalsIgnoreCase(this.thresholdType) ? Expr.Greater.create(left, right) : Expr.Lesser.create(left, right);
        }

        EventDefinitionDto createEventDefinition(EventProcessorConfig config) {
            ImmutableList notificationList = (ImmutableList)this.notifications.stream().map(notification -> EventNotificationHandler.Config.builder().notificationId(notification.id()).build()).collect(ImmutableList.toImmutableList());
            return EventDefinitionDto.builder().title((String)MoreObjects.firstNonNull((Object)this.title, (Object)"Untitled")).description("Migrated message count alert condition").config(config).alert(true).priority(2).keySpec((ImmutableList<String>)ImmutableList.of()).notificationSettings(EventNotificationSettings.builder().gracePeriodMs(this.gracePeriod * 60L * 1000L).backlogSize(this.backlogSize).build()).notifications((ImmutableList<EventNotificationHandler.Config>)notificationList).build();
        }

        String newSeriesId() {
            return UUID.randomUUID().toString();
        }
    }
}

