/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.pagerduty.client;

import com.google.common.collect.ImmutableList;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.graylog.events.notifications.EventNotificationContext;
import org.graylog.events.notifications.EventNotificationModelData;
import org.graylog.events.notifications.EventNotificationService;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog.events.processor.aggregation.AggregationEventProcessorConfig;
import org.graylog.integrations.pagerduty.PagerDutyNotificationConfig;
import org.graylog.integrations.pagerduty.dto.Link;
import org.graylog.integrations.pagerduty.dto.PagerDutyMessage;
import org.graylog2.plugin.MessageSummary;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamService;

public class MessageFactory {
    private static final List<String> PAGER_DUTY_PRIORITIES = Arrays.asList("info", "warning", "critical");
    private final StreamService streamService;
    private final EventNotificationService eventNotificationService;

    @Inject
    MessageFactory(StreamService streamService, EventNotificationService eventNotificationService) {
        this.streamService = streamService;
        this.eventNotificationService = eventNotificationService;
    }

    public PagerDutyMessage createTriggerMessage(EventNotificationContext ctx) {
        ImmutableList<MessageSummary> backlog = this.eventNotificationService.getBacklogForEvent(ctx);
        EventNotificationModelData modelData = EventNotificationModelData.of(ctx, backlog);
        PagerDutyNotificationConfig config = (PagerDutyNotificationConfig)ctx.notificationConfig();
        String eventTitle = modelData.eventDefinitionTitle();
        String eventPriority = PAGER_DUTY_PRIORITIES.get(0);
        int priority = ctx.eventDefinition().get().priority() - 1;
        if (priority >= 0 && priority <= 2) {
            eventPriority = PAGER_DUTY_PRIORITIES.get(priority);
        }
        List<Link> streamLinks = this.streamService.loadByIds(modelData.event().sourceStreams()).stream().map(stream -> this.buildStreamWithUrl((Stream)stream, ctx, config)).collect(Collectors.toList());
        String dedupKey = "";
        if (config.customIncident()) {
            dedupKey = String.format(Locale.ROOT, "%s/%s/%s", config.keyPrefix(), modelData.event().sourceStreams(), eventTitle);
        }
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("summary", modelData.event().message());
        payload.put("source", "Graylog:" + modelData.event().sourceStreams());
        payload.put("severity", eventPriority);
        payload.put("timestamp", modelData.event().eventTimestamp().toString());
        payload.put("component", "GraylogAlerts");
        payload.put("group", modelData.event().sourceStreams().toString());
        payload.put("class", "alerts");
        return new PagerDutyMessage(config.routingKey(), "trigger", dedupKey, config.clientName(), config.clientUrl(), streamLinks, payload);
    }

    private Link buildStreamWithUrl(Stream stream, EventNotificationContext ctx, PagerDutyNotificationConfig config) {
        EventDefinitionDto eventDefinitionDto;
        String graylogUrl = config.clientUrl();
        String streamUrl = StringUtils.appendIfMissing((String)graylogUrl, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + "streams/" + stream.getId() + "/search";
        if (ctx.eventDefinition().isPresent() && (eventDefinitionDto = ctx.eventDefinition().get()).config() instanceof AggregationEventProcessorConfig) {
            String query = ((AggregationEventProcessorConfig)eventDefinitionDto.config()).query();
            streamUrl = streamUrl + "?q=" + query;
        }
        try {
            return new Link(new URL(streamUrl), stream.getTitle());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Error when building the stream link URL.", e);
        }
    }
}

