/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast.functions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import javax.annotation.Nullable;
import org.graylog.plugins.pipelineprocessor.ast.functions.AutoValue_FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;

@JsonAutoDetect
@AutoValue
public abstract class FunctionDescriptor<T> {
    @JsonProperty
    public abstract String name();

    @JsonProperty
    public abstract boolean pure();

    @JsonProperty
    public abstract Class<? extends T> returnType();

    @JsonProperty
    public abstract ImmutableList<ParameterDescriptor> params();

    @JsonIgnore
    public abstract ImmutableMap<String, ParameterDescriptor> paramMap();

    @JsonIgnore
    public ParameterDescriptor param(String name) {
        return (ParameterDescriptor)this.paramMap().get((Object)name);
    }

    @JsonProperty
    @Nullable
    public abstract String description();

    @JsonProperty
    public abstract boolean ruleBuilderEnabled();

    @JsonIgnore
    @Nullable
    public abstract String ruleBuilderName();

    @JsonProperty(value="rule_builder_name")
    public String getRuleBuilderName() {
        if (this.ruleBuilderEnabled() && this.ruleBuilderName() == null) {
            return this.name();
        }
        return this.ruleBuilderName();
    }

    @JsonProperty
    @Nullable
    public abstract String ruleBuilderTitle();

    @JsonIgnore
    @Nullable
    public abstract RuleBuilderFunctionGroup ruleBuilderFunctionGroup();

    public static <T> Builder<T> builder() {
        return new AutoValue_FunctionDescriptor.Builder().pure(false).ruleBuilderEnabled(false);
    }

    @JsonCreator
    public static <T> FunctionDescriptor<T> createForRuleBuilder(@JsonProperty(value="name") String name, @JsonProperty(value="return_type") Class<? extends T> returnType, @JsonProperty(value="params") @Nullable ImmutableList<ParameterDescriptor> params, @JsonProperty(value="description") @Nullable String description, @JsonProperty(value="rule_builder_name") @Nullable String ruleBuilderName, @JsonProperty(value="rule_builder_title") @Nullable String ruleBuilderTitle, @JsonProperty(value="rule_builder_group") @Nullable RuleBuilderFunctionGroup ruleBuilderFunctionGroup) {
        return FunctionDescriptor.builder().name(name).returnType(returnType).params(params).description(description).ruleBuilderEnabled().ruleBuilderName(ruleBuilderName).ruleBuilderTitle(ruleBuilderTitle).ruleBuilderFunctionGroup(ruleBuilderFunctionGroup).build();
    }

    @AutoValue.Builder
    public static abstract class Builder<T> {
        abstract FunctionDescriptor<T> autoBuild();

        public FunctionDescriptor<T> build() {
            return this.paramMap((ImmutableMap<String, ParameterDescriptor>)Maps.uniqueIndex(this.params(), ParameterDescriptor::name)).autoBuild();
        }

        public abstract Builder<T> name(String var1);

        public abstract Builder<T> pure(boolean var1);

        public abstract Builder<T> returnType(Class<? extends T> var1);

        public abstract Builder<T> ruleBuilderEnabled(boolean var1);

        public Builder<T> ruleBuilderEnabled() {
            return this.ruleBuilderEnabled(true);
        }

        public abstract Builder<T> ruleBuilderName(String var1);

        public abstract Builder<T> ruleBuilderTitle(String var1);

        public abstract Builder<T> ruleBuilderFunctionGroup(RuleBuilderFunctionGroup var1);

        public Builder<T> params(ParameterDescriptor ... params) {
            return this.params((ImmutableList<ParameterDescriptor>)ImmutableList.builder().add((Object[])params).build());
        }

        public abstract Builder<T> params(ImmutableList<ParameterDescriptor> var1);

        public abstract Builder<T> paramMap(ImmutableMap<String, ParameterDescriptor> var1);

        public abstract ImmutableList<ParameterDescriptor> params();

        public abstract Builder<T> description(@Nullable String var1);
    }
}

