/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.dates;

import com.google.common.collect.ImmutableList;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.functions.dates.TimezoneAwareFunction;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ParseDate
extends TimezoneAwareFunction {
    public static final String NAME = "parse_date";
    private static final String VALUE = "value";
    private static final String PATTERN = "pattern";
    private static final String LOCALE = "locale";
    private final ParameterDescriptor<String, String> valueParam = ParameterDescriptor.string("value").ruleBuilderVariable().description("Date string to parse").build();
    private final ParameterDescriptor<String, String> patternParam = ParameterDescriptor.string("pattern").description("The pattern to parse the date with, see http://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html").build();
    private final ParameterDescriptor<String, String> localeParam = ParameterDescriptor.string("locale").optional().description("The locale to parse the date with, see https://docs.oracle.com/javase/8/docs/api/java/util/Locale.html").build();

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    protected ImmutableList<ParameterDescriptor> params() {
        return ImmutableList.of(this.valueParam, this.patternParam, this.localeParam);
    }

    @Override
    public DateTime evaluate(FunctionArgs args, EvaluationContext context, DateTimeZone timezone) {
        String dateString = this.valueParam.required(args, context);
        String pattern = this.patternParam.required(args, context);
        Optional<String> localeString = this.localeParam.optional(args, context);
        if (dateString == null || pattern == null) {
            return null;
        }
        Locale locale = localeString.map(Locale::forLanguageTag).orElse(Locale.getDefault());
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)pattern).withLocale(locale).withZone(timezone);
        return formatter.parseDateTime(dateString);
    }

    @Override
    protected String description() {
        return "Parses a date string using the given date format";
    }

    @Override
    @Nonnull
    protected String getRuleBuilderName() {
        return "Parse date (pattern)";
    }

    @Override
    @Nonnull
    protected String getRuleBuilderTitle() {
        return "Parse '${value}' into a DateTime using '${pattern}' pattern";
    }
}

