/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.maps;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;

public class MapGet
extends AbstractFunction<Object> {
    public static final String NAME = "map_get";
    private static final String MAPARG = "map";
    private static final String KEYARG = "key";
    private final ParameterDescriptor<Map, Map> mapParam = ParameterDescriptor.type("map", Map.class).description("A map").build();
    private final ParameterDescriptor<String, String> keyParam = ParameterDescriptor.string("key").ruleBuilderVariable().description("Get the value for this key in map").build();

    @Override
    public Object evaluate(FunctionArgs args, EvaluationContext context) {
        Map mapValue = this.mapParam.required(args, context);
        String keyValue = this.keyParam.required(args, context);
        if (mapValue == null || Strings.isNullOrEmpty((String)keyValue)) {
            return null;
        }
        return mapValue.get(keyValue);
    }

    @Override
    public FunctionDescriptor<Object> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Object.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.mapParam, this.keyParam)).description("Get a value from a map").ruleBuilderEnabled().ruleBuilderName("Get value for key in map").ruleBuilderTitle("Get value for '${key}' from map '${map}'").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.OTHER).build();
    }
}

