/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.validation;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.ValidationException;
import org.apache.commons.lang.StringUtils;
import org.graylog.plugins.views.search.rest.SeriesDescription;
import org.graylog.plugins.views.search.rest.scriptingapi.request.Metric;

public class MetricValidator {
    private final Collection<String> availableMetricTypes;
    private final Collection<String> UNSORTABLE_METRICS = List.of("latest", "percentile");

    @Inject
    public MetricValidator(Map<String, SeriesDescription> availableFunctions) {
        this.availableMetricTypes = availableFunctions.keySet();
    }

    public void validate(Metric metric) {
        if (metric == null) {
            throw new ValidationException("Metric cannot be null");
        }
        if (!this.isValidFunction(metric.functionName())) {
            throw new ValidationException("Unrecognized metric : " + metric.functionName() + ", valid metrics : " + this.availableMetricTypes);
        }
        if (!this.hasFieldIfFunctionNeedsIt(metric)) {
            throw new ValidationException(metric.functionName() + " metric requires field name to be provided after a colon, i.e. " + metric.functionName() + ":http_status_code");
        }
        if (metric.sort() != null && this.UNSORTABLE_METRICS.contains(metric.functionName())) {
            throw new ValidationException(metric.functionName() + " metric cannot be used to sort aggregations");
        }
    }

    private boolean hasFieldIfFunctionNeedsIt(Metric metric) {
        return "percentage".equals(metric.functionName()) || "count".equals(metric.functionName()) || !StringUtils.isBlank((String)metric.fieldName());
    }

    private boolean isValidFunction(String functionName) {
        return StringUtils.isNotBlank((String)functionName) && this.availableMetricTypes.contains(functionName);
    }
}

