/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.validation;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.validation.ValidationMode;
import org.graylog.plugins.views.search.validation.ValidationRequest;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

final class AutoValue_ValidationRequest
extends ValidationRequest {
    @NotNull
    private final BackendQuery query;
    @NotNull
    private final Optional<BackendQuery> filter;
    @NotNull
    private final TimeRange timerange;
    @NotNull
    private final Set<String> streams;
    @NotNull
    private final ImmutableSet<Parameter> parameters;
    @NotNull
    private final ValidationMode validationMode;

    private AutoValue_ValidationRequest(@NotNull BackendQuery query, @NotNull Optional<BackendQuery> filter, @NotNull TimeRange timerange, @NotNull Set<String> streams, @NotNull ImmutableSet<Parameter> parameters, @NotNull ValidationMode validationMode) {
        this.query = query;
        this.filter = filter;
        this.timerange = timerange;
        this.streams = streams;
        this.parameters = parameters;
        this.validationMode = validationMode;
    }

    @Override
    @NotNull
    public BackendQuery query() {
        return this.query;
    }

    @Override
    @NotNull
    public Optional<BackendQuery> filter() {
        return this.filter;
    }

    @Override
    @NotNull
    public TimeRange timerange() {
        return this.timerange;
    }

    @Override
    @NotNull
    public Set<String> streams() {
        return this.streams;
    }

    @Override
    @NotNull
    public ImmutableSet<Parameter> parameters() {
        return this.parameters;
    }

    @Override
    @NotNull
    public ValidationMode validationMode() {
        return this.validationMode;
    }

    public String toString() {
        return "ValidationRequest{query=" + this.query + ", filter=" + this.filter + ", timerange=" + this.timerange + ", streams=" + this.streams + ", parameters=" + this.parameters + ", validationMode=" + this.validationMode + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ValidationRequest) {
            ValidationRequest that = (ValidationRequest)o;
            return this.query.equals(that.query()) && this.filter.equals(that.filter()) && this.timerange.equals(that.timerange()) && this.streams.equals(that.streams()) && this.parameters.equals(that.parameters()) && this.validationMode.equals((Object)that.validationMode());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.query.hashCode();
        h$ *= 1000003;
        h$ ^= this.filter.hashCode();
        h$ *= 1000003;
        h$ ^= this.timerange.hashCode();
        h$ *= 1000003;
        h$ ^= this.streams.hashCode();
        h$ *= 1000003;
        h$ ^= this.parameters.hashCode();
        h$ *= 1000003;
        return h$ ^= this.validationMode.hashCode();
    }

    static final class Builder
    extends ValidationRequest.Builder {
        @NotNull
        private BackendQuery query;
        @NotNull
        private Optional<BackendQuery> filter = Optional.empty();
        @NotNull
        private TimeRange timerange;
        @NotNull
        private Set<String> streams;
        @NotNull
        private ImmutableSet<Parameter> parameters;
        @NotNull
        private ValidationMode validationMode;

        Builder() {
        }

        @Override
        public ValidationRequest.Builder query(@NotNull BackendQuery query) {
            if (query == null) {
                throw new NullPointerException("Null query");
            }
            this.query = query;
            return this;
        }

        @Override
        public ValidationRequest.Builder filter(@Nullable BackendQuery filter) {
            this.filter = Optional.ofNullable(filter);
            return this;
        }

        @Override
        public ValidationRequest.Builder timerange(@NotNull TimeRange timerange) {
            if (timerange == null) {
                throw new NullPointerException("Null timerange");
            }
            this.timerange = timerange;
            return this;
        }

        @Override
        public ValidationRequest.Builder streams(@NotNull Set<String> streams) {
            if (streams == null) {
                throw new NullPointerException("Null streams");
            }
            this.streams = streams;
            return this;
        }

        @Override
        public ValidationRequest.Builder parameters(@NotNull ImmutableSet<Parameter> parameters) {
            if (parameters == null) {
                throw new NullPointerException("Null parameters");
            }
            this.parameters = parameters;
            return this;
        }

        @Override
        public ValidationRequest.Builder validationMode(ValidationMode validationMode) {
            if (validationMode == null) {
                throw new NullPointerException("Null validationMode");
            }
            this.validationMode = validationMode;
            return this;
        }

        @Override
        public ValidationRequest build() {
            if (this.query == null || this.timerange == null || this.streams == null || this.parameters == null || this.validationMode == null) {
                StringBuilder missing = new StringBuilder();
                if (this.query == null) {
                    missing.append(" query");
                }
                if (this.timerange == null) {
                    missing.append(" timerange");
                }
                if (this.streams == null) {
                    missing.append(" streams");
                }
                if (this.parameters == null) {
                    missing.append(" parameters");
                }
                if (this.validationMode == null) {
                    missing.append(" validationMode");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ValidationRequest(this.query, this.filter, this.timerange, this.streams, this.parameters, this.validationMode);
        }
    }
}

