/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Optional;
import javax.inject.Inject;
import org.graylog2.bootstrap.preflight.PreflightConfig;
import org.graylog2.bootstrap.preflight.PreflightConfigResult;
import org.graylog2.bootstrap.preflight.PreflightConfigService;
import org.graylog2.database.MongoConnection;

public class PreflightConfigServiceImpl
implements PreflightConfigService {
    public static final String COLLECTION_NAME = "preflight";
    private final MongoConnection connection;

    @Inject
    public PreflightConfigServiceImpl(MongoConnection connection) {
        this.connection = connection;
    }

    private DBCollection getCollection() {
        return this.connection.getDatabase().getCollection(COLLECTION_NAME);
    }

    @Override
    public PreflightConfig setConfigResult(PreflightConfigResult result) {
        this.getCollection().update((DBObject)new BasicDBObject("type", (Object)"preflight_result"), (DBObject)new BasicDBObject("$set", (Object)new BasicDBObject("value", (Object)result)), true, false);
        return new PreflightConfig(result);
    }

    @Override
    public PreflightConfigResult getPreflightConfigResult() {
        DBObject doc = this.getCollection().findOne((DBObject)new BasicDBObject("type", (Object)"preflight_result"));
        return Optional.ofNullable(doc).map(d -> (String)d.get("value")).map(PreflightConfigResult::valueOf).orElse(PreflightConfigResult.UNKNOWN);
    }

    @Override
    public String getPreflightPassword() {
        DBObject doc = this.getCollection().findOne((DBObject)new BasicDBObject("type", (Object)"preflight_password"));
        return Optional.ofNullable(doc).map(d -> (String)d.get("value")).orElseThrow(() -> new IllegalStateException("Initial password should be automatically present in the DB, this is an inconsistent state. Please report the problem to Graylog."));
    }
}

