/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.cluster.preflight;

import com.google.common.eventbus.EventBus;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog2.cluster.preflight.DataNodeProvisioningConfig;
import org.graylog2.cluster.preflight.DataNodeProvisioningService;
import org.graylog2.cluster.preflight.DataNodeProvisioningStateChangeEvent;

public class DataNodeProvisioningBusEvents
implements DataNodeProvisioningService {
    public static final String DELEGATE_NAME = "impl";
    private final DataNodeProvisioningService delegate;
    private final EventBus eventBus;

    @Inject
    public DataNodeProvisioningBusEvents(@Named(value="impl") DataNodeProvisioningService delegate, EventBus eventBus) {
        this.delegate = delegate;
        this.eventBus = eventBus;
    }

    @Override
    public void changeState(String nodeId, DataNodeProvisioningConfig.State state) {
        this.delegate.changeState(nodeId, state);
        this.eventBus.post((Object)new DataNodeProvisioningStateChangeEvent(nodeId, state));
    }

    @Override
    public DataNodeProvisioningConfig save(DataNodeProvisioningConfig config) {
        DataNodeProvisioningConfig saved = this.delegate.save(config);
        this.eventBus.post((Object)new DataNodeProvisioningStateChangeEvent(config.nodeId(), config.state()));
        return saved;
    }

    @Override
    public Optional<DataNodeProvisioningConfig> getPreflightConfigFor(String nodeId) {
        return this.delegate.getPreflightConfigFor(nodeId);
    }

    @Override
    public List<DataNodeProvisioningConfig> findAllNodesThatNeedAttention() {
        return this.delegate.findAllNodesThatNeedAttention();
    }

    @Override
    public void writeCsr(String nodeId, String csr) {
        this.delegate.writeCsr(nodeId, csr);
    }

    @Override
    public void writeCert(String nodeId, String cert) {
        this.delegate.writeCert(nodeId, cert);
    }

    @Override
    public Optional<String> readCert(String nodeId) {
        return this.delegate.readCert(nodeId);
    }

    @Override
    public Stream<DataNodeProvisioningConfig> streamAll() {
        return this.delegate.streamAll();
    }

    @Override
    public int delete(String id) {
        return this.delegate.delete(id);
    }

    @Override
    public void deleteAll() {
        this.delegate.deleteAll();
    }
}

