/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.facades;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.events.legacy.V20190722150700_LegacyAlertConditionMigration;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.exceptions.ContentPackException;
import org.graylog2.contentpacks.facades.StreamFacade;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelType;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.NativeEntity;
import org.graylog2.contentpacks.model.entities.StreamReferenceEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.database.NotFoundException;
import org.graylog2.indexer.indexset.IndexSetService;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.shared.users.UserService;
import org.graylog2.streams.StreamRuleService;
import org.graylog2.streams.StreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamReferenceFacade
extends StreamFacade {
    private static final Logger LOG = LoggerFactory.getLogger(StreamReferenceFacade.class);
    public static final ModelType TYPE_V1 = ModelTypes.STREAM_REF_V1;
    private final ObjectMapper objectMapper;
    private final StreamService streamService;

    @Inject
    public StreamReferenceFacade(ObjectMapper objectMapper, StreamService streamService, StreamRuleService streamRuleService, V20190722150700_LegacyAlertConditionMigration legacyAlertsMigration, IndexSetService indexSetService, UserService userService) {
        super(objectMapper, streamService, streamRuleService, legacyAlertsMigration, indexSetService, userService);
        this.objectMapper = objectMapper;
        this.streamService = streamService;
    }

    @Override
    public Graph<EntityDescriptor> resolveNativeEntity(EntityDescriptor entityDescriptor) {
        MutableGraph mutableGraph = GraphBuilder.directed().build();
        mutableGraph.addNode((Object)EntityDescriptor.create(entityDescriptor.id().id(), ModelTypes.STREAM_REF_V1));
        return ImmutableGraph.copyOf((Graph)mutableGraph);
    }

    @Override
    public Optional<Entity> exportEntity(EntityDescriptor entityDescriptor, EntityDescriptorIds entityDescriptorIds) {
        ModelId modelId = entityDescriptor.id();
        if (entityDescriptorIds.get(modelId.id(), ModelTypes.STREAM_V1).isPresent()) {
            return Optional.empty();
        }
        try {
            Stream stream = this.streamService.load(modelId.id());
            return Optional.of(this.exportNativeEntity(stream, entityDescriptorIds));
        }
        catch (NotFoundException e) {
            LOG.debug("Couldn't find stream {}", (Object)entityDescriptor, (Object)e);
            return Optional.empty();
        }
    }

    @Override
    @VisibleForTesting
    Entity exportNativeEntity(Stream stream, EntityDescriptorIds entityDescriptorIds) {
        StreamReferenceEntity streamEntity = StreamReferenceEntity.create(ValueReference.of(stream.getTitle()));
        JsonNode data = (JsonNode)this.objectMapper.convertValue((Object)streamEntity, JsonNode.class);
        return ((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(entityDescriptorIds.getOrThrow(stream.getId(), ModelTypes.STREAM_REF_V1)))).type(ModelTypes.STREAM_REF_V1)).data(data).build();
    }

    @Override
    public Graph<Entity> resolveForInstallation(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities) {
        if (entity instanceof EntityV1) {
            MutableGraph mutableGraph = GraphBuilder.directed().build();
            mutableGraph.addNode((Object)entity);
            return ImmutableGraph.copyOf((Graph)mutableGraph);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    @Override
    public Optional<NativeEntity<Stream>> findExisting(Entity entity, Map<String, ValueReference> parameters) {
        if (entity instanceof EntityV1) {
            return this.findExisting((EntityV1)entity, parameters);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    @Override
    public NativeEntity<Stream> createNativeEntity(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, String username) {
        if (entity instanceof EntityV1) {
            StreamReferenceEntity streamEntity = (StreamReferenceEntity)this.objectMapper.convertValue((Object)((EntityV1)entity).data(), StreamReferenceEntity.class);
            throw new ContentPackException("Stream with title <" + streamEntity.title().asString(parameters) + "> does not exist!");
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private Optional<NativeEntity<Stream>> findExisting(EntityV1 entity, Map<String, ValueReference> parameters) {
        StreamReferenceEntity streamEntity = (StreamReferenceEntity)this.objectMapper.convertValue((Object)entity.data(), StreamReferenceEntity.class);
        List<Stream> streams = this.streamService.loadAllByTitle(streamEntity.title().asString());
        if (streams.size() == 1) {
            Stream stream = streams.get(0);
            return Optional.of(NativeEntity.create(entity.id(), stream.getId(), ModelTypes.STREAM_V1, stream.getTitle(), stream));
        }
        throw new ContentPackException(streams.isEmpty() ? "Stream with title <" + streamEntity.title().asString(parameters) + "> does not exist!" : "Multiple Streams with title <" + streamEntity.title().asString(parameters) + "> exist!");
    }

    @Override
    public EntityExcerpt createExcerpt(Stream stream) {
        return ((EntityExcerpt.Builder)((EntityExcerpt.Builder)EntityExcerpt.builder().id(ModelId.of(stream.getTitle()))).type(ModelTypes.STREAM_REF_V1)).title(stream.getTitle()).build();
    }

    @Override
    public Set<EntityExcerpt> listEntityExcerpts() {
        return this.streamService.loadAll().stream().map(this::createExcerpt).collect(Collectors.toSet());
    }

    public static Entity resolveStreamEntity(String id, Map<EntityDescriptor, Entity> entities) {
        return (Entity)StreamReferenceFacade.resolveStreamEntityObject(id, entities);
    }

    public static Object resolveStreamEntityObject(String id, Map entities) {
        Object streamEntity = entities.get(EntityDescriptor.create(id, ModelTypes.STREAM_V1));
        if (streamEntity == null) {
            streamEntity = entities.get(EntityDescriptor.create(id, ModelTypes.STREAM_REF_V1));
        }
        return streamEntity;
    }

    public static Optional<String> getStreamEntityId(String id, EntityDescriptorIds entityDescriptorIds) {
        Optional<String> descriptor = entityDescriptorIds.get(id, ModelTypes.STREAM_V1);
        if (descriptor.isEmpty()) {
            descriptor = entityDescriptorIds.get(id, ModelTypes.STREAM_REF_V1);
        }
        return descriptor;
    }

    public static String getStreamEntityIdOrThrow(String id, EntityDescriptorIds entityDescriptorIds) {
        return StreamReferenceFacade.getStreamEntityId(id, entityDescriptorIds).orElseThrow(() -> new ContentPackException("Couldn't find entity " + id + "/" + ModelTypes.STREAM_V1 + " or " + ModelTypes.STREAM_REF_V1));
    }
}

