/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.Map;
import org.graylog2.contentpacks.model.entities.AutoValue_KeywordRangeEntity;
import org.graylog2.contentpacks.model.entities.ModelTypeEntity;
import org.graylog2.contentpacks.model.entities.TimeRangeEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.KeywordRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@JsonAutoDetect
@JsonDeserialize(builder=AutoValue_KeywordRangeEntity.Builder.class)
@AutoValue
public abstract class KeywordRangeEntity
extends TimeRangeEntity {
    static final String TYPE = "keyword";
    private static final String FIELD_KEYWORD = "keyword";
    private static final String FIELD_TIMEZONE = "timezone";

    @JsonProperty(value="keyword")
    public abstract ValueReference keyword();

    @JsonProperty(value="timezone")
    public abstract ValueReference timezone();

    public static KeywordRangeEntity of(KeywordRange keywordRange) {
        String keyword = keywordRange.keyword();
        String timezone = keywordRange.timezone();
        return KeywordRangeEntity.builder().keyword(ValueReference.of(keyword)).timezone(ValueReference.of(timezone)).build();
    }

    static Builder builder() {
        return new AutoValue_KeywordRangeEntity.Builder();
    }

    @Override
    public final TimeRange convert(Map<String, ValueReference> parameters) {
        String keyword = this.keyword().asString(parameters);
        String timezone = this.timezone().asString(parameters);
        try {
            return KeywordRange.create(keyword, timezone);
        }
        catch (InvalidRangeParametersException e) {
            throw new RuntimeException("Invalid timerange.", e);
        }
    }

    @AutoValue.Builder
    static abstract class Builder
    implements TimeRangeEntity.TimeRangeBuilder<Builder> {
        Builder() {
        }

        @JsonProperty(value="keyword")
        abstract Builder keyword(ValueReference var1);

        @JsonProperty(value="timezone")
        abstract Builder timezone(ValueReference var1);

        abstract KeywordRangeEntity autoBuild();

        KeywordRangeEntity build() {
            this.type(ModelTypeEntity.of("keyword"));
            return this.autoBuild();
        }
    }
}

