/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.bson.types.ObjectId;
import org.graylog2.plugin.database.Persisted;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistedImpl
implements Persisted {
    private static final Logger LOG = LoggerFactory.getLogger(PersistedImpl.class);
    protected final Map<String, Object> fields;
    protected final ObjectId id;
    private final AtomicReference<String> hexId = new AtomicReference<Object>(null);

    protected PersistedImpl(@Nullable Map<String, Object> fields) {
        this(new ObjectId(), fields);
    }

    protected PersistedImpl(ObjectId id, @Nullable Map<String, Object> fields) {
        this.id = id;
        if (null != this.id) {
            this.hexId.set(this.id.toHexString());
        }
        if (fields == null) {
            this.fields = new HashMap<String, Object>();
        } else {
            this.fields = new HashMap<String, Object>(fields.size());
            for (Map.Entry<String, Object> field : fields.entrySet()) {
                String key = field.getKey();
                Object value = field.getValue();
                if (value instanceof Date) {
                    this.fields.put(key, new DateTime(value, DateTimeZone.UTC));
                    continue;
                }
                this.fields.put(key, value);
            }
        }
    }

    protected ObjectId getObjectId() {
        return this.id;
    }

    @Override
    public String getId() {
        String s = this.hexId.get();
        if (s == null && this.id != null) {
            String hexString = this.getObjectId().toHexString();
            this.hexId.compareAndSet(null, hexString);
            return hexString;
        }
        return s;
    }

    @Override
    @JsonIgnore
    public Map<String, Object> getFields() {
        return this.fields;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PersistedImpl)) {
            return false;
        }
        PersistedImpl other = (PersistedImpl)o;
        return Objects.equals(this.fields, other.fields) && Objects.equals(this.getObjectId(), other.getObjectId());
    }

    public int hashCode() {
        return Objects.hash(this.getObjectId(), this.getFields());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{fields=" + this.getFields() + ", id=" + this.getId() + "}";
    }

    @Override
    public Map<String, Object> asMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Method method : this.getClass().getMethods()) {
            if (!method.getName().startsWith("get") || method.getParameterTypes().length != 0) continue;
            String fieldName = method.getName().substring(3).toLowerCase(Locale.ENGLISH);
            try {
                result.put(fieldName, method.invoke((Object)this, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.debug("Error while accessing field", (Throwable)e);
            }
        }
        for (AccessibleObject accessibleObject : this.getClass().getFields()) {
            if (result.containsKey(((Field)accessibleObject).getName())) continue;
            try {
                result.put(((Field)accessibleObject).getName(), ((Field)accessibleObject).get(this));
            }
            catch (IllegalAccessException e) {
                LOG.debug("Error while accessing field", (Throwable)e);
            }
        }
        return result;
    }
}

